% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalBlm.R
\name{evalBlm}
\alias{evalBlm}
\title{Evaluate multiple blm values}
\usage{
evalBlm(values = c(), ...)
}
\arguments{
\item{values}{\code{numeric}. Values of blm to verify. More than one value is needed.}

\item{...}{arguments inherited from \code{inputData()}, \code{problem()}
and \code{solve()} functions.}
}
\value{
An object of class \linkS4class{portfolio}.
}
\description{
Return one solution per instance for different values of blm. Like
\code{prioriactions()} function, it inherits all arguments from \code{inputData()},
\code{problem()} and \code{solve()}.
}
\details{
\code{evalblm()} creates and solves multiple instances, of the corresponding
multi-actions planning problem, for different values of blm. Alternatively, this
could be obtained by executing function \code{prioriactions()} or by steps the \code{inputData()},
\code{problem()} and \code{solve()} functions; using, in each run, different blm values.
However, the \code{evalblm()} function has two advantages with
respect to this manual approach: : 1)
it is more efficient to create the models (this is because the model is created
just once and, at each iteration, only the blm values are updated); and 2) the
output is a portfolio object, which allows
obtaining information about the group of solutions (including all \emph{get} functions).
}
\examples{
\donttest{
# set seed for reproducibility
set.seed(14)

## Create model and solve
port <- evalBlm(pu = sim_pu_data, features = sim_features_data,
                dist_features = sim_dist_features_data,
                threats = sim_threats_data,
                dist_threats = sim_dist_threats_data,
                sensitivity = sim_sensitivity_data,
                boundary = sim_boundary_data,
                values = c(0.0, 0.01, 0.02, 0.03),
                model_type = "minimizeCosts",
                time_limit = 50,
                output_file = FALSE,
                cores = 2)

getConnectivityPenalty(port)
}

}
