% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-class.R
\name{data-class}
\alias{data-class}
\alias{Data}
\title{Data class}
\value{
No return value.
}
\description{
This class is used to represent data of the instances of the corresponding
multi-action planning problem. It includes several methods for retrieving the information
of the instance (such as the spatial allocation of threats and species, the cost
of management actions or the structure of the spatial connectivity across
the area where the planning is carried out. This class is created using the
\code{\link[=inputData]{inputData()}} function.
}
\section{Fields}{
 \describe{

\item{data}{\code{list} object containing data.}

}
}

\section{Methods}{
 \describe{
\item{getActionsAmount():}{
\code{integer}. Number of possible actions.}

\item{getData(\code{character} name):}{
\code{\link[=data.frame]{data.frame()}}. Object stored in the \code{data} field with the corresponding \code{name}.
The argument \code{name} indicates the name of arguments of the
\code{problem} function ("pu", "features", "dist_features", "threats",
"dist_threats", "sensitivity"
or "boundary").}

\item{getFeatureAmount():}{
\code{integer}. Number of features.}

\item{getFeatureNames():}{
\code{character}. Names of features.}

\item{getMonitoringCosts():}{
\code{numeric} \code{\link[=vector]{vector()}}. Cost of monitoring each planning unit.}

\item{getPlanningUnitsAmount():}{
\code{integer}. Number of planning units.}

\item{getActionCosts():}{
\code{numeric} \code{\link[=vector]{vector()}}. Cost of actions each planning unit and threat.}

\item{getThreatNames():}{
\code{character}. Names of threats.}

\item{getThreatsAmount():}{
\code{integer}. Number of threats.}

\item{print():}{
Print basic information of the data instance.}

\item{show():}{
Call print method.}
}
}

\examples{
## set seed for reproducibility
set.seed(14)

## Set prioriactions path
prioriactions_path <- system.file("extdata/example_input/", package = "prioriactions")

## Load in planning unit data
pu_data <- data.table::fread(paste0(prioriactions_path,"/pu.dat"),
                             data.table = FALSE)
head(pu_data)

## Load in feature data
features_data <- data.table::fread(paste0(prioriactions_path,"/features.dat"),
                                   data.table = FALSE)
head(features_data)

## Load in planning unit vs feature data
dist_features_data <- data.table::fread(paste0(prioriactions_path,"/dist_features.dat"),
                                        data.table = FALSE)
head(dist_features_data)

## Load in the threats data
threats_data <- data.table::fread(paste0(prioriactions_path,"/threats.dat"),
                                  data.table = FALSE)
head(threats_data)

## Load in the threats distribution data
dist_threats_data <- data.table::fread(paste0(prioriactions_path,"/dist_threats.dat"),
                                       data.table = FALSE)
head(dist_threats_data)

## Load in the sensitivity data
sensitivity_data <- data.table::fread(paste0(prioriactions_path,"/sensitivity.dat"),
                                      data.table = FALSE)
head(sensitivity_data)

## Load in the boundary data
boundary_data <- data.table::fread(paste0(prioriactions_path,"/boundary.dat"),
                                   data.table = FALSE)
head(boundary_data)

## Create instance
problem_data <- inputData(
  pu = pu_data, features = features_data, dist_features = dist_features_data,
  dist_threats = dist_threats_data, threats = threats_data, sensitivity = sensitivity_data,
  boundary = boundary_data
)

## Summary
print(problem_data)

## Use class methods
problem_data$getData("features")

problem_data$getFeatureAmount()

problem_data$getFeatureNames()

problem_data$getMonitoringCosts()

problem_data$getPlanningUnitsAmount()

problem_data$getActionCosts()

problem_data$getThreatNames()

problem_data$getThreatsAmount()

problem_data$print()
}
