% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esc_2024_conference_ptp.R
\name{calculate_esc_2024_symptom_score}
\alias{calculate_esc_2024_symptom_score}
\title{Calculate Symptom Score (ESC 2024)}
\usage{
calculate_esc_2024_symptom_score(
  chest_pain_type,
  have_dyspnoea,
  allow_na = TRUE
)
}
\arguments{
\item{chest_pain_type}{Input characters (no chest pain, typical, atypical, nonanginal)
to indicate the chest pain characteristics of the patient.
\itemize{
  \item no chest pain stands for the patient having no chest pain.
  \item typical stands for the patient having typical chest pain.
  \item atypical stands for the patient having atypical chest pain.
  \item nonanginal stands for the patient having nonanginal or non-specific chest pain.
}}

\item{have_dyspnoea}{Input characters (no, yes) to indicate if the patient
only has dyspnoea symptoms.
\itemize{
  \item no stands for not having dyspnoea symptoms.
  \item yes stands for having dyspnoea symptoms.
}}

\item{allow_na}{A logical evaluating to \code{TRUE} or \code{FALSE} indicating whether we can
allow `chest_pain_type` or `have_dyspnoea` to be \code{NA} when calculating the score.
Default: \code{TRUE}}
}
\value{
An integer indicating the symptom score of the patient.
It can also be \code{NA} if both \code{chest_pain_type} and \code{have_dyspnoea} are \code{NA}.
Patients with both nonanginal chest pain and dyspnoea will be given a score of 2
}
\description{
A function used to calculate the symptom score of the patient.
This is used to calculate the pretest
probability of coronary artery disease (CAD) based on the
ESC 2024 guidelines.
}
\examples{
calculate_esc_2024_symptom_score(
  chest_pain_type = "nonanginal",
  have_dyspnoea = "yes",
  allow_na = TRUE
)

calculate_esc_2024_symptom_score(
  chest_pain_type = "nonanginal",
  have_dyspnoea = NA,
  allow_na = FALSE
)

calculate_esc_2024_symptom_score(
  chest_pain_type = "nonanginal",
  have_dyspnoea = NA,
  allow_na = TRUE
)

}
