% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esc_2019_conference_ptp.R
\name{calculate_esc_2019_ptp}
\alias{calculate_esc_2019_ptp}
\title{Calculate ESC 2019 PTP for obstructive CAD}
\usage{
calculate_esc_2019_ptp(
  age,
  sex,
  have_dyspnoea,
  chest_pain_type,
  output = c("grouping", "numeric", "percentage")
)
}
\arguments{
\item{age}{Input integer value to indicate the age of the patient.}

\item{sex}{Input characters (female, male) to indicate the sex of the patient.
\itemize{
  \item female
  \item male
}}

\item{have_dyspnoea}{Input characters (no, yes) to indicate if the patient
only has dyspnoea symptoms.
\itemize{
  \item no stands for not having dyspnoea symptoms.
  \item yes stands for having dyspnoea symptoms.
}}

\item{chest_pain_type}{Input characters (no chest pain, typical, atypical, nonanginal)
to indicate the chest pain characteristics of the patient.
\itemize{
  \item no chest pain stands for the patient having no chest pain.
  \item typical stands for the patient having typical chest pain.
  \item atypical stands for the patient having atypical chest pain.
  \item nonanginal stands for the patient having nonanginal or non-specific chest pain.
}}

\item{output}{Input text to indicate the how pre-test
probability results be expressed
Default: c("grouping", "numeric", "percentage")
\itemize{
  \item grouping means the PTP will be expressed as Low, Intermediate and High.
  \itemize{
     \item low if PTP is less than 5\%.
     \item intermediate if PTP is in between 5\% to 15\%.
     \item high if PTP is more than 15\%.
  }
  \item numeric means the PTP will be expressed as an integer probability (0-100).
  \item percentage means the PTP will be expressed as percentage text (0-100\%).
}}
}
\value{
An integer, percentage or category representing the patient's PTP for obstructive CAD
based on the ESC 2019 guidelines.
See parameter option \code{output} for more information.
}
\description{
This function returns a patient's
pre-test Probability (PTP) of obstructive
coronary artery disease (CAD) based on the
European Society of Cardiology (ESC) 2019 guidelines.
}
\details{
The predictive model used to create the guidelines are based on
patients from European countries with low cardiovascular disease (CVD) risk.

If the patient has both dyspnoea and a particular
chest pain type (typical, atypical, nonanginal),
The chest pain type will take precedence over dyspnoea.
}
\examples{
# 35 year old female with typical chest pain
calculate_esc_2019_ptp(
    age = 35,
    sex = "female",
    have_dyspnoea = "no",
    chest_pain_type = "typical",
    output = "percentage"
)

# 75 year old male with only dyspnoea
calculate_esc_2019_ptp(
    age = 75,
    sex = "male",
    have_dyspnoea = "yes",
    chest_pain_type = "no chest pain",
    output = "percentage"
)
}
