% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressuRe_functions.R
\name{load_xsensor}
\alias{load_xsensor}
\title{Load xsensor data}
\usage{
load_xsensor(pressure_filepath)
}
\arguments{
\item{pressure_filepath}{String. Filepath pointing to emed pressure file}
}
\value{
A list with information about the pressure data.
\itemize{
  \item pressure_array. 2D array covering each timepoint of the measurement.
           row dimension represents time
  \item pressure_system. String defining pressure system
  \item sens_size. Numeric vector with the dimensions of the sensors
  \item time. Numeric value for time between measurements
  \item masks. List
  \item events. List
  \item sensor_polygons. Data frame with corners of sensors
  \item max_matrix. Matrix
 }
 @examples
xsensor_data <- system.file("extdata", "xsensor_data.csv", package = "pressuRe")
pressure_data <- load_xsensor(xsensor_data)
 @importFrom abind abind
 @export
}
\description{
Imports and formats files collected on xsensor insole systems
}
