% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_piped_name.R
\name{get_piped_name}
\alias{get_piped_name}
\title{get piped name}
\usage{
get_piped_name(object, default_name = "Table")
}
\arguments{
\item{object}{an object}

\item{default_name}{string Attempts to return this string if an error occurs.}
}
\value{
string
}
\description{
this function captures the name of an object piped into a function, and returns as a string. Powers the automatic naming found in presenter.
}
\examples{

#necessary to specify this option when using get_piped_name in knitr
options(rlang_trace_top_env = rlang::current_env())


### works if the object is piped or given as an argument
iris \%>\%
get_piped_name()

get_piped_name(iris)

### can even extract name from multistep pipes
iris \%>\%
dplyr::select(1:3) \%>\%
get_piped_name()

### can be placed inside other functions to capture the name and save it

find_name <- function(x){
 get_piped_name() -> new_name

 new_name
}

iris \%>\%
dplyr:select(1:3) \%>\%
find_name()

}
