% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form_to_html.R
\name{form_to_html}
\alias{form_to_html}
\title{Convert a (pre)registration form to html}
\usage{
form_to_html(
  x,
  file = NULL,
  section = NULL,
  headingLevel = 1,
  silent = preregr::opts$get("silent")
)
}
\arguments{
\item{x}{The (pre)registration form (as produced by a call
to \code{\link[=form_create]{form_create()}}) or initialized \code{preregr} object
(as produced by a call to \code{\link[=prereg_initialize]{prereg_initialize()}}).}

\item{file}{Optionally, a file to save the html to.}

\item{section}{Optionally, one or multiple sections to include (if \code{NULL},
all sections are included).}

\item{headingLevel}{The level of the top-most headings.}

\item{silent}{Whether to be silent or chatty.}
}
\value{
x, invisibly
}
\description{
Convert a (pre)registration form to html
}
\examples{
### Load an example (pre)registration specification
data("examplePrereg_1", package = "preregr");

### Extract the form and show it as HTML
preregr::form_to_html(
  examplePrereg_1
);
}
