% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01Classes.R
\name{newparam}
\alias{newparam}
\title{Create new simulation control parameter object}
\usage{
newparam(dataframe, type = "default", x, z)
}
\arguments{
\item{dataframe}{(data frame) original data to be used in simulations}

\item{type}{(character) creation type: empty, default or custom, defaults to "default"}

\item{x}{(character) primary contamination of interest such as "misval"}

\item{z}{(character) secondary contamination of interest such as "noise"}
}
\value{
preprosimparameter class object
}
\description{
Preprosim parameter objects contain eight contaminations: noise, lowvar, misval, irfeature, classswap, classimbalance, volumedecrease and outlier.
Each contamination has three sub parameters: cols as columns the contamination is applied to, param as the
parameter of the contamination itself (i.e. intensity of contamination) and order as order in which the parameter
is applied to the data.
}
\details{
For argument type: empty creates a preprosimparameter object with empty params (but not empty cols or order).
default creates 6561 combinations with all params 0, 0.1, 0.2. custom creates params seq(0, 0.9, by 0.1) for primary (x)
and 0., 0.1, 0.2 for secondary (z). The implicit y (not an argument) refers to classification accuracy.
}
\examples{
pa <- newparam(iris)
pa1 <- newparam(iris, "empty")
pa2 <- newparam(iris, "custom", "misval", "noise")
}

