% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.r
\docType{methods}
\name{sample_size}
\alias{sample_size}
\alias{sample_size.preference.trial}
\alias{sample_size.preference.trial}
\alias{power}
\alias{power.preference.trial}
\alias{effect_size}
\alias{effect_size.preference.trial}
\alias{proportion}
\alias{proportion.preference.trial}
\alias{significance}
\alias{significance.preference.trial}
\alias{sigma2}
\alias{sigma2.preference.trial}
\title{Preference trial parameter accessors}
\usage{
sample_size(x)

\method{sample_size}{preference.trial}(x)

power(x)

\method{power}{preference.trial}(x)

effect_size(x)

\method{effect_size}{preference.trial}(x)

proportion(x)

\method{proportion}{preference.trial}(x)

significance(x)

\method{significance}{preference.trial}(x)

sigma2(x)

\method{sigma2}{preference.trial}(x)
}
\arguments{
\item{x}{the set of preference trials.}
}
\description{
Accessor function have been created to get the sample size 
(sample_size), power (power), effect size (effect_size), arm proportion
(proportion), significance (significance), and trial variance estimates
(sigma2) for a set of preference trials.

Note that these methods are preferred over accessing the underlying
data frame directly since the structure is slightly non-standard (some
columns are lists) and some values, like power, are not stored directly.
}
\examples{
# Create a set of trials with a sequence of preference effects.
trials <- preference.trial(pref_ss=100, pref_effect=seq(0.1, 2, by=0.5), 
                           selection_ss=100, selection_effect=1, 
                           treatment_ss=100, treatment_effect=1, sigma2=1, 
                           pref_prop=0.6)

# the sample sizes
sample_size(trials)

# the powers
power(trials)

# the effect sizes
effect_size(trials)

# the arm proportions
proportion(trials)

# the significance
significance(trials)

# the variance estimates
sigma2(trials)

}
