% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutpoint_methods.R
\name{get_inbuilt_cutpoint}
\alias{get_inbuilt_cutpoint}
\title{Get a cutpoint using the methods inbuilt to predictNMB}
\usage{
get_inbuilt_cutpoint(predicted, actual, nmb, method)
}
\arguments{
\item{predicted}{A vector of predicted probabilities}

\item{actual}{A vector of actual outcomes}

\item{nmb}{A named vector containing NMB assigned to each classification}

\item{method}{A cutpoint selection method to be used
methods that can be used as the method argument}
}
\value{
Returns a selected cutpoint (numeric).
}
\description{
Get a cutpoint using the methods inbuilt to predictNMB
}
\examples{
## get the list of available methods:
get_inbuilt_cutpoint_methods()

## get the cutpoint that maximises the Youden index for a given set of
## probabilities and outcomes
get_inbuilt_cutpoint(
  predicted = runif(1000),
  actual = sample(c(0, 1), size = 1000, replace = TRUE),
  method = "youden"
)

}
