% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.per.year.r
\name{ci.per.year}
\alias{ci.per.year}
\alias{precintcon.ci.per.year.analysis}
\title{Concentration Index per Year}
\usage{
ci.per.year(object, interval = 1)
}
\arguments{
\item{object}{a daily precipitation serie.}

\item{interval}{the interval in millimeters applied for calculating the 
concentration index. (Default value: 1)}
}
\value{
A data.frame (precintcon.ci) containing the following variables:
\itemize{
\item \code{year} is the year.
\item \code{ci} is the concentration index.
}
}
\description{
Calculates the Concentration Index (CI) per year on a daily 
precipitation serie.
}
\examples{
##
# Loading the daily precipitation serie.
data(daily)

##
# Performing the Concentration Index Analysis
ci.per.year(daily, interval = 1)
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{pplot.lorenz}}
\code{\link{read.data}}
\code{\link{as.daily}}
}
\keyword{concentration}
\keyword{index}
\keyword{precipitation}

