% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enhance.R
\name{format.safetytab}
\alias{format.safetytab}
\title{Format a phase 1 trial safety tabulation to show significant digits only}
\usage{
\method{format}{safetytab}(x, ...)
}
\arguments{
\item{x}{A safety tabulation as found in the \code{safety} component of the
list returned by \link{summary.precautionary}.}

\item{...}{Unused; included for compatibility with generic signature}
}
\description{
The essential insight of package \link{precautionary} is distilled into the
\emph{safety tabulation} which it generates from trial simulations, reporting
the expected number of patients who will experience each grade of toxicity.
To render this table for easy interpretation, these expectations are simply
displayed with a number of significant digits appropriate to their Monte Carlo
standard errors (MCSEs).
}
\note{
The MCSEs of safety tabulations remain available for inspection
(see example), but are omitted from standard displays because they may lend
themselves to misinterpretation as \emph{confidence bounds} on the number
of patients who will experience each toxicity grade \emph{in any given trial}.
}
\examples{
mtdi_gen <- hyper_mtdi_lognormal(CV = 1
                                ,median_mtd = 5
                                ,median_sdlog = 0.5
                                ,units="mg/kg")
ordinalizer <- function(MTDi, r0 = 1.5)
  MTDi * r0 ^ c(Gr1=-2, Gr2=-1, Gr3=0, Gr4=1, Gr5=2)
old <- options(dose_levels = c(0.5, 1, 2, 4, 6)
              ,ordinalizer = ordinalizer)
get_boin(num_doses = 5, target = 0.25) \%>\%
  stop_at_n(n = 24) \%>\%
  simulate_trials(
    num_sims = 60
  , true_prob_tox = mtdi_gen) -> boin_hsims
safety <- summary(boin_hsims)$safety
safety # The print method invokes 'format.safetytab' ..
# .. but we can also inspect the underlying matrix by indexing:
safety[,]  # indexing strips 'safetytab' class, returning plain matrix
# Note that, by extend()ing the simulation we can increase precision:
if (interactive()) { # may run a bit too long for CRAN servers' taste
  boin_hsims \%>\% extend(target_mcse = 0.1) -> boin_hsimsX 
  summary(boin_hsimsX)$safety
}
options(old)
}
