% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docker.R
\name{create_docker_dir}
\alias{create_docker_dir}
\title{Create Docker directory}
\usage{
create_docker_dir(pkg_path = ".", img_path = NULL)
}
\arguments{
\item{pkg_path}{Path to the package directory. Default is \code{"."} for the current working directory, which assumes developer is working in R package root. However, this can be set to another path as needed.}

\item{img_path}{Path to the write the docker image definition contents. The default \code{NULL} will use \verb{docker/} as a subdirectory of the \code{pkg_path}.}
}
\value{
Invisibly returns a list of package info returned by \link{pkg_info}. Primarily called for side-effect to create docker directory.
}
\description{
Creates a \verb{docker/} directory for a given package. By default, assumes that \verb{docker/} should be a subdirectory of the specified package path.
}
\details{
This function is run as part of \link{use_docker} but can be used on its own.
}
\examples{
\dontrun{
# Specify path to example package source and copy to tempdir()
# Note that in practice you do not need to copy to a tempdir()
# And in fact it may be easiest to use pracpac relative to your package directory root
ex_pkg_src <- system.file("hellow", package = "pracpac", mustWork = TRUE)
file.copy(from = ex_pkg_src, to = tempdir(), recursive = TRUE)

# Assuming default behavior then docker/ will be created under source root
create_docker_dir(pkg_path = file.path(tempdir(), "hellow"))

# Alternatively you can specify another directory above, below, or beside package source
create_docker_dir(pkg_path = file.path(tempdir(), "hellow"), img_path = file.path(tempdir(), "img"))
}

}
