% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawHPIntensity.R
\name{drawHPIntensity}
\alias{drawHPIntensity}
\title{Draw the intensity of Hawkes Process}
\usage{
drawHPIntensity(
  hp = NULL,
  events,
  int_title = "Hawkes Intensity",
  start = 0,
  end = max(events),
  history = NULL,
  color = 1,
  i = 1,
  add = FALSE,
  fit = FALSE,
  plot_events = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{hp}{object parameters for Hawkes process.}

\item{events}{the event times happened in this state}

\item{int_title}{title of the intensity plot}

\item{start}{the start time of current state}

\item{end}{the end time of current state}

\item{history}{the past event times}

\item{color}{specify the default plotting color.}

\item{i}{state number, used only for drawUniMMHPIntensity}

\item{add}{whether to add the hawkes intensity to an existing plot, used
for drawUniMMHPIntensity}

\item{fit}{a boolean indicating whether to fit a new HP to events}

\item{plot_events}{indicate whether events will be plotted}

\item{verbose}{whether to output informative messages as running}
}
\value{
no return value, intensity plot of Hawkes process
}
\description{
Draw the intensity of a Hawkes Process
}
\examples{
hp_obj <- pp_hp(lambda0 = 0.5, alpha = 0.45, beta = 0.5)
events <- pp_simulate(hp_obj, start = 0, end = 20)
drawHPIntensity(hp_obj,events)
}
