% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova1way.c.bal.R
\name{anova1way.c.bal}
\alias{anova1way.c.bal}
\title{Power calculation for one-way balanced analysis of variance contrast test}
\usage{
anova1way.c.bal(
  n = NULL,
  mvec = NULL,
  cvec = NULL,
  sd = 1,
  Rsq = 0,
  ncov = 0,
  alpha = 0.05,
  power = NULL,
  v = FALSE
)
}
\arguments{
\item{n}{The sample size per group.}

\item{mvec}{A vector of group means c(mu1, mu2, ...).}

\item{cvec}{A vector of contrast coefficients c(c1, c2, ...).}

\item{sd}{The estimated standard deviation within each group; defaults to 1.}

\item{Rsq}{The estimated R^2 for regressing the outcome on the covariates; defaults to 0.}

\item{ncov}{The number of covariates adjusted for in the model; defaults to 0.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Performs sample size and power calculations for a test of a contrast in a one-way
ANOVA with balanced data (that is, equal sized groups). Can be used to solve for
power, n (sample size per group), or alpha. For unbalanced data, see
anova1way.c.unbal.
}
\examples{
anova1way.c.bal(n = 20, mvec = c(5, 10, 12), cvec = c(1, -1, 0), sd = 10, alpha = 0.025)
anova1way.c.bal(n = 20, mvec = c(5, 10, 12), cvec = c(1, 0, -1), sd = 10, alpha = 0.025)
}
