% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.power.anova.R
\name{boot.power.anova}
\alias{boot.power.anova}
\title{Bootstrap the Power of an ANOVA Design}
\usage{
boot.power.anova(design, n_from, n_to, num_iterations_bootstrap, alpha = 0.05)
}
\arguments{
\item{design}{object of type \code{\link{design.anova}}}

\item{n_from}{numeric, lower boundary of sample size range (inclusive)
; Refers to N per between condition}

\item{n_to}{numeric, upper boundary of sample size range (inclusive)
; Refers to N per between condition}

\item{num_iterations_bootstrap}{numeric, number of bootstrap iterations for each sample size}

\item{alpha}{numeric, alpha level}
}
\value{
list containing power-by-samplesize data.frames for each effect
}
\description{
This function bootstraps the power of each effect in an ANOVA design for a given range
of sample sizes. Power is computed by randomly drawing samples from a multivariate normal
distribution specified according to the values supplied by the \code{\link{design.anova}}
object. Power is defined as the proportion of bootstrap iterations the p-values of each
effect lie below the supplied alpha level. Note that this function runs many ANOVAs which
might be slow for large sample size ranges or bootstrap iterations (see Details below).
Further note that this function does not check for assumptions such as sphericity.
}
\details{
Note that this function requires the computation of many ANOVAs and therefore becomes
slow with increasing sample size ranges and bootstrap iterations. It is therefore suggested
to first use a very low number of bootstrap iterations, such as 10, in order to determine
a sensible sample size range for the power of interest. Once done, use this small sample
size range and dramatically increase the bootstrap iterations, such as 3000, in order to
determine more reliable power estimates. Because the power-by-samplesize function is
monotonically increasing, a zigzag of power values with increasing sample sizes indicates
that the selected bootstrap iterations are too low.
}
\examples{
\dontrun{
design <- design.anova(
   between = list(age = c("young","old"),
                  sex = c("male","female")),
   within = list(condition = c("cond1","cond2","cond3")),
   default_within_correlation = 0.7
)

power_by_samplesize <- boot.power.anova(
   design,
   n_from = 40,
   n_to = 60,
   num_iterations_bootstrap = 1000
)

plot(power_by_samplesize,
     crit_power = 0.9,
     plot_dir = "power_plots")
}

}
\seealso{
\code{\link{design.anova}}, \code{\link{plot.power_by_samplesize}}
}

