% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bkg.R
\name{bkg}
\alias{bkg}
\title{Fit a background to XRPD data}
\usage{
bkg(xrd, lambda, hwi, it, int)
}
\arguments{
\item{xrd}{an xy data frame of the data to fit a background to. First column
is the 2theta scale, second column is count intensities}

\item{lambda}{2nd derivative penalty for primary smoothing}

\item{hwi}{Half width of local windows}

\item{it}{Number of iterations in suppression loop}

\item{int}{Number of buckets to divide the data into}
}
\value{
a list of 3 vectors
\item{tth}{The 2theta axis of the measurement}
\item{counts}{The count intensities of the measurement}
\item{background}{The fitted background}
}
\description{
\code{bkg} fits a background to X-Ray Powder Diffraction data
}
\details{
A wrapper for the \code{baseline.fillPeaks} in the \code{baseline} package.
}
\examples{
data(soils)
fit_bkg <- bkg(soils$granite)
}
