% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence.R
\name{ess_sd}
\alias{ess_sd}
\alias{ess_sd.default}
\alias{ess_sd.rvar}
\title{Effective sample size for the standard deviation}
\usage{
ess_sd(x, ...)

\method{ess_sd}{default}(x, ...)

\method{ess_sd}{rvar}(x, ...)
}
\arguments{
\item{x}{(multiple options) One of:
\itemize{
\item A matrix of draws for a single variable (iterations x chains). See
\code{\link[=extract_variable_matrix]{extract_variable_matrix()}}.
\item An \code{\link{rvar}}.
}}

\item{...}{Arguments passed to individual methods (if applicable).}
}
\value{
If the input is an array, returns a single numeric value. If any of the draws
is non-finite, that is, \code{NA}, \code{NaN}, \code{Inf}, or \code{-Inf}, the returned output
will be (numeric) \code{NA}. Also, if all draws within any of the chains of a
variable are the same (constant), the returned output will be (numeric) \code{NA}
as well. The reason for the latter is that, for constant draws, we cannot
distinguish between variables that are supposed to be constant (e.g., a
diagonal element of a correlation matrix is always 1) or variables that just
happened to be constant because of a failure of convergence or other problems
in the sampling process.

If the input is an \code{\link{rvar}}, returns an array of the same dimensions as the
\code{\link{rvar}}, where each element is equal to the value that would be returned by
passing the draws array for that element of the \code{\link{rvar}} to this function.
}
\description{
Compute an effective sample size estimate for the standard deviation (SD)
estimate of a single variable. This is defined as minimum of the effective
sample size estimate for the mean and the the effective sample size estimate
for the mean of the squared value.
}
\examples{
mu <- extract_variable_matrix(example_draws(), "mu")
ess_sd(mu)

d <- as_draws_rvars(example_draws("multi_normal"))
ess_sd(d$Sigma)

}
\references{
Aki Vehtari, Andrew Gelman, Daniel Simpson, Bob Carpenter, and
Paul-Christian Bürkner (2019). Rank-normalization, folding, and
localization: An improved R-hat for assessing convergence of
MCMC. \emph{arXiv preprint} \code{arXiv:1903.08008}.
}
\seealso{
Other diagnostics: 
\code{\link{ess_basic}()},
\code{\link{ess_bulk}()},
\code{\link{ess_quantile}()},
\code{\link{ess_tail}()},
\code{\link{mcse_mean}()},
\code{\link{mcse_quantile}()},
\code{\link{mcse_sd}()},
\code{\link{rhat_basic}()},
\code{\link{rhat}()},
\code{\link{rstar}()}
}
\concept{diagnostics}
