% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight_draws.R
\name{weights.draws}
\alias{weights.draws}
\title{Extract Weights from Draws Objects}
\usage{
\method{weights}{draws}(object, log = FALSE, normalize = TRUE, ...)
}
\arguments{
\item{object}{(draws) A \code{\link{draws}} object.}

\item{log}{(logical) Should the weights be returned on the log scale?
Defaults to \code{FALSE}.}

\item{normalize}{(logical) Should the weights be normalized to sum to 1 on
the standard scale? Defaults to \code{TRUE}.}

\item{...}{Arguments passed to individual methods (if applicable).}
}
\value{
A vector of weights, with one weight per draw.
}
\description{
Extract weights from \code{\link{draws}} objects, with one weight per draw.
See \code{\link{weight_draws}} for details how to add weights to \code{\link{draws}} objects.
}
\examples{
x <- example_draws()

# sample some random weights for illustration
wts <- rexp(ndraws(x))
head(wts)

# add weights
x <- weight_draws(x, weights = wts)

# extract weights
head(weights(x)) # defaults to normalized weights
head(weights(x, normalize=FALSE)) # recover original weights
head(weights(x, log=TRUE)) # get normalized log-weights

# add weights which are already on the log scale
log_wts <- log(wts)
head(log_wts)

x <- weight_draws(x, weights = log_wts, log = TRUE)
# extract weights
head(weights(x))
head(weights(x, log=TRUE, normalize = FALSE)) # recover original log_wts

}
\seealso{
\code{\link{weight_draws}}, \code{\link{resample_draws}}
}
