% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_compare.R
\name{pp_compare}
\alias{pp_compare}
\title{Comparison to Other Data}
\usage{
pp_compare(x, estimated, actual, title)
}
\arguments{
\item{x}{An object of class \code{sf} including estimated and actual
values}

\item{estimated}{Population estimates using \link[populR]{pp_estimate}
function}

\item{actual}{Actual population values}

\item{title}{Scatterplot title \code{string}}
}
\value{
A list including rmse, mae, linear model details and correlation coefficient
}
\description{
Comparison to Other Data
}
\examples{
# read lib data
data('src')
data('trg')

# areal weighting interpolation - awi
awi <- pp_estimate(trg, src, sid = sid, spop = pop,
    method = awi)

# volume weighting interpolation - vwi
vwi <- pp_estimate(trg, src, sid = sid, spop = pop,
    method = vwi, volume = floors)

# awi - rmse
pp_compare(awi, estimated = pp_est, actual = rf,
    title ='awi')

# vwi - rmse
pp_compare(vwi, estimated = pp_est, actual = rf,
    title ='vwi')

}
