% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bruvo.r
\name{bruvo.boot}
\alias{bruvo.boot}
\title{Create a tree using Bruvo's Distance with non-parametric bootstrapping.}
\usage{
bruvo.boot(pop, replen = 1, add = TRUE, loss = TRUE, sample = 100,
  tree = "upgma", showtree = TRUE, cutoff = NULL, quiet = FALSE,
  root = NULL, ...)
}
\arguments{
\item{pop}{a \code{\link{genind}} object}

\item{replen}{a \code{vector} of \code{integers} indicating the length of the
  nucleotide repeats for each microsatellite locus.}

\item{add}{if \code{TRUE}, genotypes with zero values will be treated under
  the genome addition model presented in Bruvo et al. 2004.}

\item{loss}{if \code{TRUE}, genotypes with zero values will be treated under
  the genome loss model presented in Bruvo et al. 2004.}

\item{sample}{an \code{integer} indicated the number of bootstrap replicates
  desired.}

\item{tree}{any function that can generate a tree from a distance matrix.
  Default is \code{\link[phangorn]{upgma}}.}

\item{showtree}{\code{logical} if \code{TRUE}, a tree will be plotted with
  nodelabels.}

\item{cutoff}{\code{integer} the cutoff value for bootstrap node label values
  (between 0 and 100).}

\item{quiet}{\code{logical} defaults to \code{FALSE}. If \code{TRUE}, a
  progress bar and messages will be suppressed.}

\item{root}{\code{logical} This is a parameter passed on to
  \code{\link[ape]{boot.phylo}}. If the \code{tree} argument produces a
  rooted tree (e.g. "upgma"), then this value should be \code{TRUE}. If it
  produces an unrooted tree (e.g. "nj"), then the value should be
  \code{FALSE}. By default, it is set to \code{NULL}, which will assume an
  unrooted phylogeny unless the function name contains "upgma".}

\item{...}{any argument to be passed on to \code{\link{boot.phylo}}. eg.
  \code{quiet = TRUE}.}
}
\value{
a tree of class phylo with nodelables
}
\description{
Create a tree using Bruvo's Distance with non-parametric bootstrapping.
}
\details{
This function will calculate a tree based off of Bruvo's distance
  and then utilize \code{\link[ape]{boot.phylo}} to randomly sample loci with
  replacement, recalculate the tree, and tally up the bootstrap support
  (measured in percent success). While this function can take any tree
  function, it has native support for two algorithms: \code{\link[ape]{nj}}
  and \code{\link[phangorn]{upgma}}. If you want to use any other functions,
  you must load the package before you use them (see examples).
}
\note{
\strong{Please refer to the documentation for bruvo.dist for details on
  the algorithm.} If the user does not provide a vector of appropriate length
  for \code{replen} , it will be estimated by taking the minimum difference
  among represented alleles at each locus. IT IS NOT RECOMMENDED TO RELY ON
  THIS ESTIMATION.
}
\examples{
# Please note that the data presented is assuming that the nancycat dataset
# contains all dinucleotide repeats, it most likely is not an accurate
# representation of the data.

# Load the nancycats dataset and construct the repeat vector.
data(nancycats)
ssr <- rep(2, 9)

# Analyze the 1st population in nancycats

bruvo.boot(popsub(nancycats, 1), replen = ssr)

\dontrun{

# Always load the library before you specify the function.
library("ape")

# Estimate the tree based off of the BIONJ algorithm.

bruvo.boot(popsub(nancycats, 9), replen = ssr, tree = bionj)

# Utilizing  balanced FastME
bruvo.boot(popsub(nancycats, 9), replen = ssr, tree = fastme.bal)

# To change parameters for the tree, wrap it in a function.
# For example, let's build the tree without utilizing subtree-prune-regraft

myFastME <- function(x) fastme.bal(x, nni = TRUE, spr = FALSE, tbr = TRUE)
bruvo.boot(popsub(nancycats, 9), replen = ssr, tree = myFastME)

}
}
\author{
Zhian N. Kamvar, Javier F. Tabima
}
\references{
Ruzica Bruvo, Nicolaas K. Michiels, Thomas G. D'Souza, and
Hinrich Schulenburg. A simple method for the calculation of microsatellite
genotype distances irrespective of ploidy level. Molecular Ecology,
13(7):2101-2106, 2004.
}
\seealso{
\code{\link{bruvo.dist}}, \code{\link{nancycats}},
  \code{\link{upgma}}, \code{\link{nj}}, \code{\link{boot.phylo}},
  \code{\link{nodelabels}}, \code{\link{tab}},
  \code{\link{missingno}}.
}

