% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{gethierarchy}
\alias{addhierarchy}
\alias{addhierarchy,genclone-method}
\alias{addhierarchy<-}
\alias{addhierarchy<-,genclone-method}
\alias{gethierarchy}
\alias{gethierarchy,genclone-method}
\alias{namehierarchy}
\alias{namehierarchy,genclone-method}
\alias{namehierarchy<-}
\alias{namehierarchy<-,genclone-method}
\alias{sethierarchy}
\alias{sethierarchy,genclone-method}
\alias{sethierarchy<-}
\alias{sethierarchy<-,genclone-method}
\alias{splithierarchy}
\alias{splithierarchy,genclone-method}
\alias{splithierarchy<-}
\alias{splithierarchy<-,genclone-method}
\title{Access and manipulate the population hierarchy for genclone objects.}
\usage{
gethierarchy(x, formula = NULL, combine = TRUE)

sethierarchy(x, value)

sethierarchy(x) <- value

namehierarchy(x, value)

namehierarchy(x) <- value

splithierarchy(x, value, sep = "_")

splithierarchy(x) <- value

addhierarchy(x, value, name = "NEW")

addhierarchy(x) <- value
}
\arguments{
\item{x}{a genclone object}

\item{formula}{a nested formula indicating the order of the population
hierarchy.}

\item{combine}{if \code{TRUE}, the levels will be combined according to the
formula argument. If it is \code{FALSE}, the levels will not be combined.}

\item{value}{a data frame OR vector OR formula (see details).}

\item{sep}{a \code{character} indicating the character used to separate
hierarchical levels. This defaults to "_".}

\item{name}{an optional name argument for use with addhierarchy if supplying
a vector. Defaults to "NEW".}
}
\description{
The following methods allow the user to quickly change the hierarchy or
population of a genclone object.
}
\details{
\subsection{Function Specifics}{ \itemize{ \item
\strong{gethierarchy()} - This will retrieve the data from the
\emph{hierarchy} slot in the \linkS4class{genclone} object. You have the
option to choose specific heirarchical levels using a formula (see below) and
you can choose to combine the hierarchical levels (default) \item
\strong{sethierarchy()} - Set or reset the hierarchical levels in your
\linkS4class{genclone} object. \item \strong{namehierarchy()} - Rename the
hierarchical levels. \item \strong{splithierarchy()} - This is conceptually
similar to the default method of \code{\link{splitcombine}}. It is often
difficult to import files with several levels of hierarchy as most data
formats do not allow unlimited population levels. This is circumvented by
collapsing all hierarchical levels into a single population factor with a
common separator for each observation. This function will then split those
hierarchies for you, but it works best on a hierarchy that only has a single
column in it. See the rootrot example below. \item \strong{addhierarchy()} -
Add levels to your population hierarchy. If you have extra hierarchical
levels you want to add to your population hierarchy, you can use this method
to do so. You can input a data frame or a vector, but if you put in a vector,
you have the option to name it (if you are using the functional version and
not the assignment version). }}

\subsection{Argument Specifics}{

These functions allow the user to seamlessly assign the hierarchical levels
of their \code{\linkS4class{genclone}} object. Note that there are two ways
of performing all methods (except for \code{gethierarchy()}). They
essentially do the same thing except that the assignment method (the one with
the "\code{<-}") will modify the object in place whereas the non-assignment
method will not modify the original object. Due to convention, everything
right of the assignment is termed \code{value}. To avoid confusion, here is a
guide to the inputs: \itemize{ \item \strong{sethierarchy()} This will be a
\code{\link{data.frame}} that defines the hierarchy for each individual in
the rows. \item \strong{namehierarchy()} This will be either a
\code{\link{vector}} or a \code{\link{formula}} that will define the names.
\item \strong{splithierarchy()} This will be a \code{\link{formula}} argument
with the same number of levels as the hierarchy you wish to split. \item
\strong{addhierarchy()} This will be a \code{\link{vector}} or
\code{\link{data.frame}} with the same length as the number of individuals in
your data. }}

\subsection{Details on Formulas}{

The preferred use of these functions is with a \code{\link{formula}} object.
Specifically, a hierarchical formula argument is used to assign the levels of
the hierarchy. An example of a hierarchical formula would be:\cr
\code{~Country/City/Neighborhood}\cr or \cr \code{~Country + Country:City +
Country:City:Neighborhood}\cr of course, the first method is slightly easier
to read. It is important to use hiearchical formulas when specifying
hierarchies as other types of formulas (eg.
\code{~Country*City*Neighborhood}) might give spurious results.}
}
\examples{
# let's look at the microbov data set:
data(microbov)
microgc <- as.genclone(microbov)
microgc

# We see that we have three vectors of different names here.
?microbov
# These are Country, Breed, and Species
names(other(microgc))

# Let's set the hierarchy
sethierarchy(microgc) <- data.frame(other(microgc))
microgc

# And change the names so we know what they are
namehierarchy(microgc) <- ~Country/Breed/Species

# let's see what the hierarchy looks like by Species and Breed:
head(gethierarchy(microgc, ~Breed/Species))

\dontrun{
# Load our data set and convert it to a genclone object.
Aeut.gc <- read.genalex(system.file("files/rootrot.csv", package = "poppr"))

# we can see the hierarchy is set to Population_Subpopulation.
head(gethierarchy(Aeut.gc))

# We can use splithierarchy() to split them.
splithierarchy(Aeut.gc) <- ~Pop/Subpop
Aeut.gc
head(gethierarchy(Aeut.gc))

# We can also use gethierarchy to combine the hierarchy.
head(gethierarchy(Aeut.gc, ~Pop/Subpop))

# We can also give it a more descriptive name.
namehierarchy(Aeut.gc) <- ~Population/Subpopulation
Aeut.gc
Aeut.gc <- namehierarchy(Aeut.gc, ~Pop/Subpop)
Aeut.gc
}
}
\author{
Zhian N. Kamvar
}
\seealso{
\code{\link{setpop}} \code{\link{genclone}}
  \code{\link{as.genclone}}
}

