% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stoch.sens.R
\name{stoch.sens}
\alias{stoch.sens}
\title{Stochastic growth rate sensitivity}
\usage{
stoch.sens(A, tlimit = 100)
}
\arguments{
\item{A}{a list of matrices}

\item{tlimit}{time limit, default 100}
}
\value{
A list with two elements:
  \item{sensitivities}{ sensitivities of the stochastic growth rate }
  \item{elasticities}{ elasticities of the stochastic growth rate }
}
\description{
Calculates the sensitivity of the stochastic growth rate to perturbations in
the mean demographic projection matrix
}
\details{
Function copied from demogR package after it was removed from CRAN.
See section 14.4.1 in Caswell 2001.
}
\examples{
stoch.sens(hudsonia)

}
\references{
Caswell, H. 2001. Matrix population models: construction,
analysis, and interpretation, Second edition. Sinauer, Sunderland,
Massachusetts, USA.

Haridas, C. V., and S. Tuljapurkar. 2005. Elasticities in variable
environments: Properties and implications. American Naturalist 166
(4):481-495.

Tuljapurkar, S. 1990. Population dynamics in variable environments.
Vol. 85, Lecture notes in biomathematics. Berlin: Springer-Veralg.

Tuljapurkar, S., and C. V. Haridas. 2006. Temporal autocorrelation and
stochastic population growth. Ecology Letters 9 (3):324-334.
}
\seealso{
\code{\link{eigen.analysis}}
}
\author{
James Holland Jones
}
