% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_document.R
\name{sire}
\alias{sire}
\title{sire - a simulated cohort of Finnish female rectal cancer patients}
\format{data.table with columns
\itemize{
 \item sex - gender of the patient (1 = female)
 \item bi_date - date of birth
 \item dg_date - date of cancer diagnosis
 \item ex_date - date of exit from follow-up (death or censoring)
 \item status  - status of the person at exit; 0 alive; 1 dead due to pertinent cancer; 2 dead due to other causes
 \item dg_age  - age at diagnosis expressed as fractional years
}}
\source{
The Finnish Cancer Registry
}
\description{
\code{sire} is a simulated cohort pertaining female Finnish rectal cancer patients
diagnosed between 1993-2012. Instead of actual original dates, the dates are masked
via modest randomization within several time windows.
}
\details{
The closing date for the pertinent data was 2012-12-31, meaning status information was
available only up to that point --- hence the maximum possible \code{ex_date} is \code{2012-12-31}.
}
\author{
Karri Seppa
}
\seealso{
Other popEpi_data: \code{\link{ICSS}},
  \code{\link{popmort}}, \code{\link{sibr}},
  \code{\link{stdpop101}}, \code{\link{stdpop18}}

Other survival_data: \code{\link{sibr}}
}

