% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relocate.R, R/select.R
\name{relocate}
\alias{relocate}
\alias{select}
\title{Select/relocate variables by name}
\usage{
relocate(.data, ..., .before = NULL, .after = NULL)

select(.data, ...)
}
\arguments{
\item{.data}{A \code{data.frame}.}

\item{...}{The name(s) of the column(s) to select.}

\item{.before, .after}{Destination of the columns selected by \code{...}. Supplying neither will move the columns to the
left-hand side whereas supplying both will result in an error.}
}
\value{
A \code{data.frame}.
}
\description{
Choose or relocate variables from a \code{data.frame}. \code{select()} keeps only the
variables you mention; \code{relocate()} keeps all the variables.
}
\section{Useful functions}{

There are a number of special functions which are designed to work in \code{select()} and \code{relocate()}:
\itemize{
\item \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}
\item \code{\link[=matches]{matches()}}
\item \code{\link[=num_range]{num_range()}}
\item \code{\link[=everything]{everything()}}
}
}

\examples{
select(mtcars, mpg, cyl)
select(mtcars, MilesPerGallon = mpg, Cylinders = cyl)
mtcars \%>\% select(mpg)
mtcars \%>\% select(mpg, cyl)
iris \%>\% select(contains("Petal"))

df <- as.data.frame(matrix(runif(100), nrow = 10))
df <- as.data.frame(df[c(3, 4, 7, 1, 9, 8, 5, 2, 6, 10)])
df \%>\% select(num_range("V", 4:6))

mtcars \%>\% relocate(ends_with("p"), .before = mpg)

}
