% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_trans.R
\docType{methods}
\name{parameter transformations}
\alias{parameter transformations}
\alias{parameter_trans}
\alias{parameter_trans,missing,missing-method}
\alias{parameter_trans,ANY,ANY-method}
\alias{parameter_trans,ANY,missing-method}
\alias{parameter_trans,NULL,NULL-method}
\alias{parameter_trans,missing,ANY-method}
\alias{parameter_trans,pomp_fun,pomp_fun-method}
\alias{parameter_trans,Csnippet,Csnippet-method}
\alias{parameter_trans,character,character-method}
\alias{parameter_trans,function,function-method}
\title{Parameter transformations}
\usage{
parameter_trans(toEst, fromEst, ...)

\S4method{parameter_trans}{`NULL`,`NULL`}(toEst, fromEst, ...)

\S4method{parameter_trans}{pomp_fun,pomp_fun}(toEst, fromEst, ...)

\S4method{parameter_trans}{Csnippet,Csnippet}(toEst, fromEst, ..., log, logit, barycentric)

\S4method{parameter_trans}{character,character}(toEst, fromEst, ...)

\S4method{parameter_trans}{function,function}(toEst, fromEst, ...)
}
\arguments{
\item{toEst, fromEst}{procedures that perform transformation of model parameters to and from the estimation scale, respectively.
These can be furnished using C snippets, \R functions, or via procedures in an external, dynamically loaded library.}

\item{\dots}{ignored.}

\item{log}{names of parameters to be log transformed.}

\item{logit}{names of parameters to be logit transformed.}

\item{barycentric}{names of parameters to be collectively transformed according to the log barycentric transformation.
\strong{Important note:} variables to be log-barycentrically transformed \emph{must be adjacent} in the parameter vector.}
}
\description{
Equipping models with parameter transformations to ease searches in constrained parameter spaces.
}
\details{
When parameter transformations are desired, they can be integrated into the \sQuote{pomp} object via the \code{partrans} arguments using the \code{parameter_trans} function.
As with the other \link[=basic components]{basic model components}, these should ordinarily be specified using C snippets.
When doing so, note that:
\enumerate{
  \item The parameter transformation mapping a parameter vector from the scale used by the model codes to another scale, and the inverse transformation, are specified via a call to \preformatted{parameter_trans(toEst,fromEst)}.
  \item The goal of these snippets is the transformation of the parameters from the natural scale to the estimation scale, and vice-versa.
  If \code{p} is the name of a variable on the natural scale, its value on the estimation scale is \code{T_p}.
  Thus the \code{toEst} snippet computes \code{T_p} given \code{p} whilst the \code{fromEst} snippet computes \code{p} given \code{T_p}.
  \item Time-, state-, and covariate-dependent transformations are not allowed.
  Therefore, neither the time, nor any state variables, nor any of the covariates will be available in the context within which a parameter transformation snippet is executed.
}

These transformations can also be specified using \R functions with arguments chosen from among the parameters.
Such an \R function must also have the argument \sQuote{\code{...}}.
In this case, \code{toEst} should transform parameters from the scale that the basic components use internally to the scale used in estimation.
\code{fromEst} should be the inverse of \code{toEst}.

Note that it is the user's responsibility to make sure that the transformations are mutually inverse.
If \code{obj} is the constructed \sQuote{pomp} object, and \code{coef(obj)} is non-empty, a simple check of this property is \preformatted{
  x <- coef(obj, transform = TRUE)
  obj1 <- obj
  coef(obj1, transform = TRUE) <- x
  identical(coef(obj), coef(obj1))
  identical(coef(obj1, transform=TRUE), x)}

One can use the \code{log} and \code{logit} arguments of \code{parameter_trans} to name variables that should be log-transformed or logit-transformed, respectively.
The \code{barycentric} argument can name sets of parameters that should be log-barycentric transformed.

Note that using the \code{log}, \code{logit}, or \code{barycentric} arguments causes C snippets to be generated.
Therefore, you must make sure that variables named in any of these arguments are also mentioned in \code{paramnames} at the same time.

The logit transform is defined by
\deqn{\mathrm{logit}(\theta)=\log\frac{\theta}{1-\theta}.}{logit(theta) = log(theta/(1-theta)).}

The log barycentric transformation of variables \eqn{\theta_1,\dots,\theta_n}{theta1,\dots,thetan} is given by
\deqn{\mathrm{logbarycentric}(\theta_1,\dots,\theta_n)=\left(\log\frac{\theta_1}{\sum_i \theta_i},\dots,\log\frac{\theta_n}{\sum_i \theta_i}\right).}{logbarycentric(theta1,\dots,thetan)=(log(theta1/sum(theta)),\dots,log(thetan/sum(theta))).}
}
\section{Note for Windows users}{


Some Windows users report problems when using C snippets in parallel computations.
These appear to arise when the temporary files created during the C snippet compilation process are not handled properly by the operating system.
To circumvent this problem, use the \code{\link[=pomp]{cdir}} and \code{\link[=pomp]{cfile}} options to cause the C snippets to be written to a file of your choice, thus avoiding the use of temporary files altogether.
}

\seealso{
\code{\link{partrans}}

More on implementing POMP models: 
\code{\link{Csnippet}},
\code{\link{accumulator variables}},
\code{\link{basic components}},
\code{\link{covariates}},
\code{\link{distributions}},
\code{\link{dmeasure specification}},
\code{\link{dprocess specification}},
\code{\link{pomp-package}},
\code{\link{pomp}},
\code{\link{prior specification}},
\code{\link{rinit specification}},
\code{\link{rmeasure specification}},
\code{\link{rprocess specification}},
\code{\link{skeleton specification}},
\code{\link{transformations}},
\code{\link{userdata}}
}
\concept{implementation information}
