% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{marker_binning_list}
\alias{marker_binning_list}
\title{Bin markers that are in a nested list}
\usage{
marker_binning_list(dosage_matrix, linkage_list, r_thresh = NA,
  lod_thresh = NA, return_removed_marker_info = FALSE, log = NULL, ...)
}
\arguments{
\item{dosage_matrix}{A dosage \code{matrix}}

\item{linkage_list}{A nested \code{list} with linkage group on the first level and homologue on the second.}

\item{r_thresh}{Numeric. Threshold at which markers are binned. Is calculated if NA.}

\item{lod_thresh}{Numeric. Threshold at which markers are binned. Is calculated if NA.}

\item{return_removed_marker_info}{Logical. Should removed marker information be returned? If TRUE, output is a
list containing the linkage list with binned markers removed and a dataframe with removed marker information.}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}

\item{\dots}{Arguments passed to \code{\link{marker_binning}}}
}
\value{
A list of linkage \code{data.frames} with binned markers removed.
If \code{return_removed_marker_info = TRUE}, a list containing the above linkage dataframes (linkage_list) and a dataframe
with removed marker information, called removed_markers.
}
\description{
This is a wrapper for \code{\link{marker_binning}}.
It applies \code{\link{marker_binning}} to a nested list as output of \code{\link{split_linkage_info}}
}
\examples{
data("screened_data3", "all_linkages_list_P1_split")
mb<-marker_binning_list(screened_data3,
                     all_linkages_list_P1_split,
                     target_parent="P1",
                     other_parent="P2")
}
