% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_degree.R
\name{degree}
\alias{degree}
\alias{degree,numeric-method}
\alias{degree,matrix-method}
\alias{degree,polynomial-method}
\alias{degree,polyMatrix-method}
\title{Gets maximum degree of polynomial objects}
\usage{
degree(x)

\S4method{degree}{numeric}(x)

\S4method{degree}{matrix}(x)

\S4method{degree}{polynomial}(x)

\S4method{degree}{polyMatrix}(x)
}
\arguments{
\item{x}{an \R objects}
}
\value{
The value is an integer number which can be different from zero only
for polynomial objects.
}
\description{
Returns the maximum degree as an integer number.
}
\details{
By default, this function raises
error for unknown type of object.

A numerical scalar has zero degree.

A numerical matrix has zero degree as each of its items has zero degree as well.

For polynomials this function returns the highest degree of its terms with non-zero coefficient.
}
\section{Methods (by class)}{
\itemize{
\item \code{numeric}: a scalar argument always has zero degree

\item \code{matrix}: a numerical matrix always has zero degree

\item \code{polynomial}: the degree of a polynomial

\item \code{polyMatrix}: the degree of a polynomial matrix is the highest degree of its elements
}}

\examples{

# numerical
degree(1)  ## 0


# numerical matrix
degree(matrix(1:6, 3, 2)) ## 0


# polinomial
degree(parse.polynomial("1")) ## 0
degree(parse.polynomial("1 + x")) ## 1
degree(parse.polynomial("1 + x^3")) ## 3


# polynomial matrices
degree(parse.polyMatrix(
   "x; x^2 + 1",
   "0; 2x"))
## 2

}
