% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4classes.R, R/textstat.R, R/view.R
\docType{class}
\name{textstat-class}
\alias{textstat-class}
\alias{as.data.frame,textstat-method}
\alias{show,textstat-method}
\alias{dim,textstat-method}
\alias{colnames,textstat-method}
\alias{rownames,textstat-method}
\alias{names,textstat-method}
\alias{as.DataTables,textstat-method}
\alias{name,textstat-method}
\alias{name<-,textstat,character-method}
\alias{head,textstat-method}
\alias{tail,textstat-method}
\alias{dim,textstat-method}
\alias{nrow,textstat-method}
\alias{round,textstat-method}
\alias{colnames,textstat-method}
\alias{sort,textstat-method}
\alias{as.bundle}
\alias{+,textstat,textstat-method}
\alias{subset,textstat-method}
\alias{as.data.table,textstat-method}
\alias{as.data.frame,textstat-method}
\alias{p_attributes,textstat-method}
\alias{[[,textstat-method}
\alias{[,textstat,ANY,ANY,ANY-method}
\alias{view,textstat-method}
\title{S4 textstat class}
\usage{
\S4method{name}{textstat}(x)

\S4method{name}{textstat,character}(x) <- value

\S4method{head}{textstat}(x, ...)

\S4method{tail}{textstat}(x, ...)

\S4method{dim}{textstat}(x)

\S4method{nrow}{textstat}(x)

\S4method{round}{textstat}(x, digits = 2)

\S4method{colnames}{textstat}(x)

\S4method{sort}{textstat}(x, by, decreasing = TRUE)

as.bundle(object, ...)

\S4method{+}{textstat,textstat}(e1, e2)

\S4method{subset}{textstat}(x, ...)

\S4method{as.data.table}{textstat}(x)

\S4method{as.data.frame}{textstat}(x)

\S4method{p_attributes}{textstat}(.Object)

\S4method{[[}{textstat}(x, i)

\S4method{[}{textstat,ANY,ANY,ANY}(x, i, j)

\S4method{view}{textstat}(.Object)
}
\arguments{
\item{x}{textstat object}

\item{value}{A \code{character} vector to assign as name to slot \code{name}
of a \code{textstat} class object.}

\item{...}{further parameters}

\item{digits}{no of digits}

\item{by}{by}

\item{decreasing}{logical}

\item{object}{a textstat object}

\item{e1}{object 1}

\item{e2}{object 2}

\item{.Object}{an object}

\item{i}{vector to index data.table in stat-slot}

\item{j}{vector to index data.table in stat-slot}
}
\description{
Superclass for \code{features}, \code{context}, and \code{partition} class.
}
\details{
Objects derived from the \code{textstat} class can be indexed with simple
square brackets ("[") to get rows specified by an numeric/integer vector,
and with double square brackets ("[[") to get specific columns from the 
\code{data.table} in the slot \code{stat}.

\code{textstat} objects can have a name, which can be retrieved, and set using
the \code{name}-method and \code{name<-}, respectively.
}
\section{Slots}{

\describe{
\item{\code{p_attribute}}{Object of class \code{"character"} p-attribute of the query}

\item{\code{corpus}}{Object of class \code{"character"}}

\item{\code{stat}}{Object of class \code{"data.table"} statistics of the analysis}

\item{\code{name}}{name of the object}

\item{\code{encoding}}{Object of class \code{"character"} encoding of the corpus}
}}

\examples{
use("polmineR")
P <- partition("GERMAPARLMINI", date = ".*", p_attribute = "word", regex = TRUE)
y <- cooccurrences(P, query = "Arbeit")
y[1:25]
y[,c("word", "ll")]
y[1:25, "word"]
y[1:25][["word"]]
y[which(y[["word"]] \%in\% c("Arbeit", "Sozial"))]
y[ y[["word"]] \%in\% c("Arbeit", "Sozial") ]
}
