% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode_method.R
\docType{methods}
\name{encode}
\alias{encode}
\alias{encode,data.frame-method}
\alias{encode,data.table-method}
\title{Encode CWB Corpus.}
\usage{
encode(.Object, ...)

\S4method{encode}{data.frame}(.Object, name, pAttributes = "word",
  sAttributes = NULL, registry = Sys.getenv("CORPUS_REGISTRY"),
  indexedCorpusDir = NULL, verbose = TRUE)

\S4method{encode}{data.table}(.Object, corpus, sAttribute)
}
\arguments{
\item{.Object}{a data.frame to encode}

\item{...}{further parameters}

\item{name}{name of the (new) CWB corpus}

\item{pAttributes}{columns of .Object with tokens (such as word/pos/lemma)}

\item{sAttributes}{columns of .Object that will be encoded as structural attributes}

\item{registry}{path to the corpus registry}

\item{indexedCorpusDir}{directory where to create directory for indexed corpus files}

\item{verbose}{logical, whether to be verbose}

\item{corpus}{the name of the CWB corpus}

\item{sAttribute}{a single s-attribute}
}
\description{
Encode CWB Corpus.
}
