% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4classes.R, R/textstat.R, R/view.R
\docType{class}
\name{textstat-class}
\alias{textstat-class}
\alias{as.data.frame,textstat-method}
\alias{show,textstat-method}
\alias{dim,textstat-method}
\alias{colnames,textstat-method}
\alias{rownames,textstat-method}
\alias{names,textstat-method}
\alias{as.DataTables,textstat-method}
\alias{head,textstat-method}
\alias{tail,textstat-method}
\alias{nrow,textstat-method}
\alias{ncol,textstat-method}
\alias{as.data.table,textstat-method}
\alias{round,textstat-method}
\alias{sort,textstat-method}
\alias{[,textstat,ANY,ANY,ANY-method}
\alias{[[,textstat-method}
\alias{name}
\alias{name<-}
\alias{name,textstat-method}
\alias{name<-,textstat,character-method}
\alias{round,textstat-method}
\alias{sort,textstat-method}
\alias{as.bundle}
\alias{+,textstat,textstat-method}
\alias{subset,textstat-method}
\alias{p_attributes,textstat-method}
\alias{knit_print,textstat-method}
\alias{view,textstat-method}
\title{S4 textstat superclass.}
\usage{
\S4method{name}{textstat}(x)

\S4method{name}{textstat,character}(x) <- value

\S4method{round}{textstat}(x, digits = 2L)

\S4method{sort}{textstat}(x, by, decreasing = TRUE)

as.bundle(object, ...)

\S4method{+}{textstat,textstat}(e1, e2)

\S4method{subset}{textstat}(x, ...)

\S4method{p_attributes}{textstat}(.Object)

\S4method{knit_print}{textstat}(x,
  pagelength = getOption("polmineR.pagelength"),
  options = knitr::opts_chunk, ...)

\S4method{view}{textstat}(.Object)
}
\arguments{
\item{x}{A \code{textstat} object.}

\item{value}{A \code{character} vector to assign as name to slot \code{name}
of a \code{textstat} class object.}

\item{digits}{no of digits}

\item{by}{Column that will serve as the key for sorting.}

\item{decreasing}{Logical, whether to return decreasing order.}

\item{object}{a textstat object}

\item{...}{Further arguments.}

\item{e1}{A \code{texstat} object.}

\item{e2}{Another \code{texstat} object.}

\item{.Object}{A \code{textstat} object.}

\item{pagelength}{The number of kwic lines displayed per page in the
datatables htmlwidget that is returned.}

\item{options}{Chunk options.}
}
\description{
The \code{textstat}-class (technically an S4 class) serves as a superclass
for the classes \code{features}, \code{context}, and \code{partition}.
Usually, the class will not be used directly. It offers a set of standard
generic methods (such as \code{head}, \code{tail}, \code{dim}, \code{nrow},
\code{colnames}) its childs inherit. The core feature of \code{textstat} and
its childs is a \code{data.table} in the slot \code{stat} for keeping data on
text statistics of a corpus, or a \code{partition}.
}
\details{
A \code{head}-method will return the first rows of the \code{data.table} in
the \code{stat}-slot. Use argument \code{n} to specify the number of rows.

A \code{tail}-method will return the last rows of the \code{data.table} in
the \code{stat}-slot. Use argument \code{n} to specify the number of rows.

The methods \code{dim}, \code{nrow} and \code{ncol} will return information
on the dimensions, the number of rows, or the number of columns of the
\code{data.table} in the \code{stat}-slot, respectively.

Objects derived from the \code{textstat} class can be indexed with simple
square brackets ("[") to get rows specified by an numeric/integer vector,
and with double square brackets ("[[") to get specific columns from the 
\code{data.table} in the slot \code{stat}.

The \code{colnames}-method will return the column names of the \code{data-table}
in the slot \code{stat}.

The methods \code{as.data.table}, and \code{as.data.frame} will extract the
\code{data.table} in the slot \code{stat} as a \code{data.table}, or
\code{data.frame}, respectively.

\code{textstat} objects can have a name, which can be retrieved, and set using
the \code{name}-method and \code{name<-}, respectively.
}
\section{Slots}{

\describe{
\item{\code{p_attribute}}{Object of class \code{character}, p-attribute of the query.}

\item{\code{corpus}}{A corpus specified by a length-one \code{character} vector.}

\item{\code{stat}}{A \code{data.table} with statistical information.}

\item{\code{name}}{The name of the object.}

\item{\code{encoding}}{A length-one \code{character} vector, the encoding of the corpus.}
}}

\examples{
use("polmineR")
P <- partition("GERMAPARLMINI", date = ".*", p_attribute = "word", regex = TRUE)
y <- cooccurrences(P, query = "Arbeit")

# Standard generic methods known from data.frames work for objects inheriting
# from the textstat class

head(y)
tail(y)
nrow(y)
ncol(y)
dim(y)
colnames(y)

# Use brackets for indexing 

y[1:25]
y[,c("word", "ll")]
y[1:25, "word"]
y[1:25][["word"]]
y[which(y[["word"]] \%in\% c("Arbeit", "Sozial"))]
y[ y[["word"]] \%in\% c("Arbeit", "Sozial") ]
}
