% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R
\name{scan_csv}
\alias{scan_csv}
\alias{read_csv}
\title{new LazyFrame from csv}
\arguments{
\item{path}{string, Path to a file or URL}

\item{sep}{Single char to use as delimiter in the file.}

\item{has_header}{bool, indicate if the first row of dataset is a header or not.
If set to False, column names will be autogenerated in the following format:
column_x, with x being an enumeration over every column in the dataset starting at 1.}

\item{ignore_errors}{bool, try to keep reading lines if some lines yield errors. First try
infer_schema_length=0 to read all columns as pl.Utf8 to check which values might cause
an issue.}

\item{skip_rows}{integer, Start reading after skip_rows lines. The header will be parsed
at this offset.}

\item{n_rows}{int (NULL is disable),Stop reading from CSV file after reading n_rows.}

\item{cache}{bool, cache the result after reading.}

\item{overwrite_dtype}{(NULL is disable) named list of dtypes OR dtype-names, where name points
to a column. Can overwrite dtypes during inference.
Supported types so far are:
name | alias | polars side dtype
"Boolean" | "logical" => DataType::Boolean,
"Float32" | "double" => DataType::Float32,
"Float64" | "float64" => DataType::Float64,
"Int32" | "integer" => DataType::Int32,
"Int64" | "integer64" => DataType::Int64,
"Utf8" | "character" => DataType::Utf8,}

\item{low_memory}{bool, reduce memory usage in expense of performance}

\item{comment_char}{(NULL is disable) Single byte character that indicates the start of a comment line,
for instance #.}

\item{quote_char}{(NULL is disable) Single byte character used for csv quoting, default = ". Set to None
to turn off special handling and escaping of quotes.}

\item{null_values}{(NULL is disable) Values to interpret as null values. You can provide a
String : All values equal to this string will be null.
Unnamed char vector: A null value per column.
Named char vector.  A mapping from (names)column to a null value string(values).}

\item{infer_schema_length}{Maximum number of rows to read to infer the column
types. If set to 0, all columns will be read as UTF-8. If \code{NULL}, a full
table scan will be done (slow).}

\item{skip_rows_after_header}{bool Skip this number of rows when the header is parsed.}

\item{encoding}{either "utf8" or "utf8-lossy". Lossy means that invalid utf8 values are replaced with "?" characters.}

\item{row_count_name}{String(NULL is disable), name of a added row count column}

\item{row_count_offset}{integer, Offset to start the row_count column (only used if the name is set).}

\item{parse_dates}{bool Try to automatically parse dates. If this does not succeed, the column remains of data type pl.Utf8.}

\item{reuse_downloaded}{Boolean. If \code{TRUE}(default) and a URL was provided,
cache the downloaded files in session for an easy reuse.}
}
\value{
scan_csv returns a LazyFrame. read_csv returns a DataFrame.

DataFrame
}
\description{
will scan the csv when collect(), not now.
read_csv is a shortcut for scan_csv$collect().
}
\details{
Read a file from path into a polars lazy frame. Not yet supporting eol_char and with_column_names
}
\examples{
my_file = tempfile()
write.csv(iris, my_file)
lazy_frame = pl$scan_csv(path = my_file)
lazy_frame$collect()
unlink(my_file)
}
\keyword{LazyFrame_new}
