% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_add.R
\name{info_section}
\alias{info_section}
\title{Add information that focuses on some key aspect of the data table}
\usage{
info_section(x, section_name, ...)
}
\arguments{
\item{x}{An informant object of class \code{ptblank_informant}.}

\item{section_name}{The name of the section for which this information
pertains.}

\item{...}{Information entries as a series of named arguments. The names
refer to subsection titles within the section defined as \code{section_name} and
the RHS is the \emph{info text} (informational text that can be written as
Markdown and further styled with \emph{Text Tricks}).}
}
\value{
A \code{ptblank_informant} object.
}
\description{
While the \code{\link[=info_tabular]{info_tabular()}} and \code{\link[=info_columns]{info_columns()}} functions allow us to
add/modify info text for specific sections, the \code{info_section()}
makes it possible to add sections of our own choosing and the information
that make sense for those sections. Define a \code{section_name} and provide a
series of named arguments (in the form \code{entry_name = "The *info text*."}) to
build the informational content for that section.
}
\details{
The \emph{info text} readily accepts Markdown formatting. Also, there are a few
\emph{Text Tricks} that are good to know. Markdown links written as \verb{< link url >}
or \verb{[ link text ]( link url )} will get nicely-styled links. Any dates
expressed in the ISO-8601 standard with parentheses, \code{"(2004-12-01)"}, will
be styled with a font variation (monospaced) and underlined in purple. Spans
of text can be converted to label text by using: (1) double parentheses
around text for a rectangular label as in \verb{((label text))}, or (2) triple
parentheses around text for a rounded-rectangular label like \verb{(((label text)))}. Finally, CSS styles can be applied to spans of \emph{info text} with
the following form:

\verb{[[ info text ]]<< CSS style rules >>}

As an example of this in practice suppose you'd like to change the color of
some text to red and make the font appear somewhat thinner. A variation on
the following might be used:

\code{"This is a [[factor]]<<color: red; font-weight: 300;>> value."}
}
\section{Figures}{

\if{html}{\figure{man_info_section_1.png}{options: width=100\%}}
}

\section{Function ID}{

3-3
}

\examples{
# Create a pointblank `informant`
# object with `create_informant()`;
# we specify a `read_fn` with the
# `~` followed by a statement that
# gets the `small_table` dataset
informant <- 
  create_informant(
    read_fn = ~ small_table,
    tbl_name = "small_table",
    label = "An example."
  )

# The `informant` object has the 'table'
# and 'columns' sections; we can create
# entirely different sections with their
# own properties using `info_section()`
informant <-
  informant \%>\%
  info_section(
    section_name = "notes",
    creation = "Dataset generated on (2020-01-15).",
    usage = "`small_table \%>\% dplyr::glimpse()`"
  )

# Upon printing the `informant` object, we see
# the addition of the 'Notes' section and its
# own information

# The `informant` object can be written to
# a YAML file with the `yaml_write()`
# function; then, information can
# be directly edited or modified
# yaml_write(
#   informant = informant,
#   filename = "informant.yml"
# )

# The YAML file can then be read back
# into an informant object with the
# `yaml_read_informant()` function
# informant <-
#   yaml_read_informant(path = "informant.yml")

}
\seealso{
Other Information Functions: 
\code{\link{info_columns}()},
\code{\link{info_snippet}()},
\code{\link{info_tabular}()}
}
\concept{Information Functions}
