% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_agent_report.R
\name{get_agent_report}
\alias{get_agent_report}
\title{Get a simple report from an agent}
\usage{
get_agent_report(agent, display_table = TRUE)
}
\arguments{
\item{agent}{An agent object of class \code{ptblank_agent}.}

\item{display_table}{Should a display table be generated? If \code{TRUE}, and if
the \strong{gt} package is installed, a display table for the report will be
shown in the Viewer. If \code{FALSE}, or if \strong{gt} is not available, then a
tibble will be returned.}
}
\value{
A tibble.
}
\description{
We can get the essential information from an agent by using the
\code{get_agent_report()} function. The amount of fields with intel is different
depending on whether or not the agent performed an interrogation (with
\code{interrogate()}). The tibble that is returned has the following columns:
\itemize{
\item i: the validation step number
\item type: the validation type, which mirrors the name of the validation
step function
\item columns: the names of the columns used in the validation step
\item value: the numeric value used in the validation step, where applicable
\item set: the set values used in the validation step; for a \code{conjointly()}
validation step, this is a listing of all sub-validations
\item regex: the regex used for a \code{col_vals_regex()} validation step
\item preconds: a logical value indicating whether any preconditions where
applied before interrogation
\item units: the total number of validation units for the validation step
\item n_pass: the number of validation units that received a \emph{pass}
\item f_pass: the fraction of validation units that received a \emph{pass}
\item W: a logical value stating whether the \code{warn} state was entered
\item S: a logical value stating whether the \code{stop} state was entered
\item N: a logical value stating whether the \code{notify} state was entered
\item extract: a logical value that indicates whether a data extract is
available for the validation step
}
If the \strong{gt} package is installed (and if \code{display_table = TRUE}) then a
\strong{gt} table will be displayed with the same information.
}
\section{Function ID}{

3-3
}

\examples{
library(dplyr)

# Create a simple table with a
# column of numerical values
tbl <- tibble(a = c(5, 7, 8, 5))

# Validate that values in column
# `a` are always greater than 4
agent <-
  create_agent(tbl = tbl) \%>\%
  col_vals_gt(vars(a), 4) \%>\%
  interrogate()

# Get a tibble-based report from the
# agent by using `get_agent_report()`
agent \%>\%
  get_agent_report(display_table = FALSE)

}
\seealso{
Other Interrogate and Get Info: 
\code{\link{all_passed}()},
\code{\link{get_data_extracts}()},
\code{\link{interrogate}()}
}
\concept{Interrogate and Get Info}
