% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/res.comp.R
\name{res.comp}
\alias{res.comp}
\title{Calculate resilience components: resistance, recovery, resilience and relative resilience}
\usage{
res.comp(data, nb.yrs = 4, res.thresh.neg = 40, series.thresh = 75)
}
\arguments{
\item{data}{a \code{data.frame} with tree-ring series as columns and years as rows (e.g., output of \code{read.rwl}, \code{bai.in} or \code{bai.out} of package dplR)}

\item{nb.yrs}{an \code{integer} specifying the number of years for pre- and post-disturbance periods to be considered in calculating resilience components. Defaults to 4.}

\item{res.thresh.neg}{a \code{numeric} specifying the threshold below which the resistance, expressed as a percentual change (i.e. relative growth reduction), is considered a negative event year for individual trees and years. Defaults to 40.}

\item{series.thresh}{a \code{numeric} specifying the minimum percentage of trees that should display a negative event year for that year to be considered as negative pointer year. Defaults to 75.}
}
\value{
The function returns a \code{list} containing the following components:
\item{resist}{a \code{matrix} with resistance values (i.e. relative growth changes) for individual tree-ring series}
\item{EYvalues}{a \code{matrix} indicating negative (-1) and non-event years (0) for individual tree-ring series}
\item{recov}{a \code{matrix} with recovery values for individual tree-ring series}
\item{resil}{a \code{matrix} with resilience values for individual tree-ring series}
\item{rel.resil}{a \code{matrix} with relative resilience values for individual tree-ring series}
\item{out}{a \code{data.frame} containing the following columns:}
\item{}{\code{year} - time stamp}
\item{}{\code{nb.series} - number of series considered}
\item{}{\code{perc.neg} - percentage of trees showing a negative event year}
\item{}{\code{nature} - number indicating whether the year is a negative (-1) or no pointer year (0)}
\item{}{\code{resist_mean} - mean resistance as percentual change over the available series}
\item{}{\code{resist_sd} - standard deviation of the resistance}
\item{}{\code{recov_mean} - mean recovery as percentual change over the available series}
\item{}{\code{recov_sd} - standard deviation of the recovery}
\item{}{\code{resil_mean} - mean resilience as percentual change over the available series}
\item{}{\code{resil_sd} - standard deviation of the resilience}
\item{}{\code{rel.resil_mean} - mean relative resilience calculated over the available series}
\item{}{\code{rel.resil_sd} - standard deviation of the relative resilience}
\item{out.select}{a \code{data.frame} containing a subset of rows from \code{out} that provide all statistics for years that were identified as negative pointer years}
\item{spec.param}{a \code{data.frame} specifying the arguments used in the calculation}
}
\description{
The function calculates resilience components on a \code{data.frame} of tree-ring series after Lloret et al. (2011), useful to analyze growth of individual trees prior, during and after extreme events / disturbances. The component 'resistance' is conceptually identical to 'abrupt growth changes' as described in Schweingruber et al. (1990). To identify negative event and pointer years, thresholds can be set as for the function \code{\link{pointer.rgc}}. 'Recovery' is the ability of tree growth to recover after disturbance, whereas 'resilience' reflects the ability of trees to reach pre-disturbance growth levels. Weighting of the resilience by the experienced growth reduction results in 'relative resilience'.
}
\details{
The function calculates the resilience components resistance, recovery, resilience and relative resilience as described in Lloret et al. (2011). A threshold on resistance can be set to identify negative event years for trees (cf. \code{\var{rgc.thresh.neg}} in function \code{\link{pointer.rgc}}), which are used to define negative pointer years for the site.

If \code{\var{nb.yrs}}, \code{\var{res.thresh.neg}} and \code{\var{series.thresh}} are set to 4, 40 and 75 respectively, a negative pointer year will be defined when at least 75\% of the tree-ring series display an event year with resistance values indicating a growth decrease of at least 40\%, relative to the average growth in the 4 preceding years. The output provides the resilience components for all possible years, as well as for the selected pointer years separately.

Note that the resulting time series are truncated by \code{\var{nb.yrs}} at both ends inherent to the calculation methods.
}
\examples{
## Calculate resilience components on tree-ring series
data(s033)
res <- res.comp(s033, nb.yrs = 4, res.thresh.neg = 40, series.thresh = 75)
res$out
res$out.select
}
\author{
Marieke van der Maaten-Theunissen and Ernst van der Maaten.
}
\references{
Lloret, F., Keeling, E.G. and Sala, A. (2011) Components of tree resilience: effects of successive low-growth episodes in old ponderosa pine forests. \emph{Oikos} 120: 1909-1920.

Schweingruber, F.H., Eckstein, D., Serre-Bachet, F. and \enc{Bräker}{Braker}, O.U. (1990) Identification, presentation and interpretation of event years and pointer years in dendrochronology. \emph{Dendrochronologia} 8: 9-38.
}

