% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example2.R
\name{example2_lgss}
\alias{example2_lgss}
\title{Parameter estimation in a linear Gaussian state space model}
\usage{
example2_lgss(nIter = 5000)
}
\arguments{
\item{nIter}{The number of iterations in the PMH algorithm. 100 iterations 
takes about ten seconds on a laptop to execute. 5000 iterations are used 
in the reference below. The length of the burn-in is calculated as one 
fifth of nIter.}
}
\value{
Returns the estimate of the posterior mean.
}
\description{
Minimal working example of parameter estimation in a linear Gaussian state 
space model using the particle Metropolis-Hastings algorithm with a 
fully-adapted particle filter for providing an unbiased estimator of the 
likelihood. The code estimates the parameter posterior for one parameter 
using simulated data.
}
\details{
The Particle Metropolis-Hastings (PMH) algorithm makes use of a Gaussian 
random walk as the proposal for the parameter. The PMH algorithm is run 
using different step lengths in the proposal. This is done to illustrate 
the difficulty when tuning the proposal and the impact of a too 
small/large step length.
}
\note{
See Section 4.4 in the reference for more details.
}
\examples{
\dontrun{
# Use a short run when testing the code on CRAN
# Set nIter manually if running on local computer
# nIter=1000 is usually enough
if(nchar(Sys.getenv("LONG_TEST")) != 0) {
  nIter=7500
} else {
  nIter=100
}
 
# Run the example script
example2_lgss(nIter=100) 
}
}
\author{
Johan Dahlin <johan.dahlin@liu.se>
}
\references{
Dahlin, J. & Schoen, T. B. "Getting started with particle 
Metropolis-Hastings for inference in nonlinear dynamical models." 
pre-print, arXiv:1511.01707, 2015.
}
\keyword{misc}

