% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{layer_white_bg}
\alias{layer_white_bg}
\alias{layer_bg}
\alias{layer_reticle}
\alias{layer_dot}
\alias{layer_bars}
\alias{layer_pie}
\alias{layer_violin}
\alias{layer_boxplot}
\title{Heatmap layer functions used to draw on the heatmap cells}
\usage{
layer_white_bg(j, i, x, y, w, h, fill)

layer_bg(j, i, x, y, w, h, fill, alpha)

layer_reticle(j, i, x, y, w, h, fill, color)

layer_dot(j, i, x, y, w, h, fill, hmdf, dot_size, alpha)

layer_bars(j, i, x, y, w, h, fill, col_fun, hmdf, alpha)

layer_pie(j, i, x, y, w, h, fill, palette, palcolor, hmdf, pie_size)

layer_violin(j, i, x, y, w, h, fill, hmdf, violin_fill)

layer_boxplot(j, i, x, y, w, h, fill, hmdf, boxplot_fill)
}
\arguments{
\item{j}{An integer specifying the column index}

\item{i}{An integer specifying the row index}

\item{x}{A numeric vector specifying the x position}

\item{y}{A numeric vector specifying the y position}

\item{w}{A numeric vector specifying the width}

\item{h}{A numeric vector specifying the height}

\item{fill}{A character vector specifying the fill color}

\item{alpha}{A numeric value between 0 and 1 specifying the transparency of the fill color}

\item{color}{A character vector specifying the color of the reticle}

\item{hmdf}{A dataframe used to create the annotation. Different from the data used to
create the heatmap itself, which is aggregated data. This dataframe is the original data,
where each cell could have multiple values.}

\item{dot_size}{A numeric value specifying the size of the dot or a function to calculate the size
from the values in the cell}

\item{col_fun}{A function to calculate the color of the bars}

\item{violin_fill}{A character vector specifying the fill color of the violin plot.
If not provided, the fill color of row/column annotation will be used}

\item{boxplot_fill}{A character vector specifying the fill color of the boxplot.
If not provided, the fill color of row/column annotation will be used}
}
\description{
Heatmap layer functions used to draw on the heatmap cells
}
\keyword{internal}
