% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordcloudplot.R
\name{WordCloudPlotAtomic}
\alias{WordCloudPlotAtomic}
\title{Word cloud without data splitting}
\usage{
WordCloudPlotAtomic(
  data,
  word_by = NULL,
  sentence_by = NULL,
  count_by = NULL,
  score_by = NULL,
  count_name = NULL,
  score_name = NULL,
  words_excluded = plotthis::words_excluded,
  score_agg = mean,
  minchar = 2,
  word_size = c(2, 8),
  top_words = 100,
  facet_by = NULL,
  facet_scales = "fixed",
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_byrow = TRUE,
  theme = "theme_this",
  theme_args = list(),
  palette = "Paired",
  palcolor = NULL,
  alpha = 1,
  palreverse = FALSE,
  aspect.ratio = 1,
  legend.position = "right",
  legend.direction = "vertical",
  title = NULL,
  subtitle = NULL,
  seed = 8525,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{word_by}{A character string of the column name to use as the word.
A character column is expected.}

\item{sentence_by}{A character string of the column name to split the sentence.
A character column is expected.
Either \code{word_by} or \code{sentence_by} should be specified.}

\item{count_by}{A character string of the column name for the count of the word/sentence.
A numeric column is expected.
If NULL, the count of the word/sentence will be used.}

\item{score_by}{A character string of the column name for the score of the word/sentence.
A numeric column is expected, used for the color of the word cloud.
If NULL, the score will be set to 1.}

\item{count_name}{A character string to name the legend of count.}

\item{score_name}{A character string to name the legend of score.}

\item{words_excluded}{A character vector of words to exclude from the word cloud.}

\item{score_agg}{A function to aggregate the scores. Default is \code{mean}.}

\item{minchar}{A numeric value specifying the minimum number of characters for the word.}

\item{word_size}{A numeric vector specifying the range of the word size.}

\item{top_words}{A numeric value specifying the number of top words to show.}

\item{facet_by}{A character string specifying the column name of the data frame to facet the plot.
Otherwise, the data will be split by \code{split_by} and generate multiple plots
and combine them into one using \code{patchwork::wrap_plots}}

\item{facet_scales}{Whether to scale the axes of facets. Default is "fixed"
Other options are "free", "free_x", "free_y". See \code{ggplot2::facet_wrap}}

\item{facet_ncol}{A numeric value specifying the number of columns in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_nrow}{A numeric value specifying the number of rows in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_byrow}{A logical value indicating whether to fill the plots by row. Default is TRUE.}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{palette}{A character string specifying the palette to use.}

\item{palcolor}{A character string specifying the color to use in the palette.}

\item{alpha}{A numeric value specifying the transparency of the plot.}

\item{palreverse}{A logical value to reverse the palette colors.}

\item{aspect.ratio}{A numeric value specifying the aspect ratio of the plot.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{seed}{The random seed to use. Default is 8525.}

\item{...}{Additional arguments.}
}
\value{
A ggplot object
}
\description{
Word cloud without data splitting
}
\keyword{internal}
