% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcanoplot.R
\name{VolcanoPlotAtomic}
\alias{VolcanoPlotAtomic}
\title{Atomic volcano plot}
\usage{
VolcanoPlotAtomic(
  data,
  x,
  y,
  ytrans = function(n) -log10(n),
  color_by = NULL,
  color_name = NULL,
  flip_negatives = FALSE,
  x_cutoff = NULL,
  y_cutoff = 0.05,
  x_cutoff_name = NULL,
  y_cutoff_name = NULL,
  x_cutoff_color = "red2",
  y_cutoff_color = "blue2",
  x_cutoff_linetype = "dashed",
  y_cutoff_linetype = "dashed",
  x_cutoff_linewidth = 0.5,
  y_cutoff_linewidth = 0.5,
  pt_size = 2,
  pt_alpha = 0.5,
  nlabel = 5,
  labels = NULL,
  label_size = 3,
  label_fg = "black",
  label_bg = "white",
  label_bg_r = 0.1,
  highlight = NULL,
  highlight_color = "red",
  highlight_size = 2,
  highlight_alpha = 1,
  highlight_stroke = 0.5,
  facet_by = NULL,
  facet_scales = "fixed",
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_byrow = TRUE,
  theme = "theme_this",
  theme_args = list(),
  palette = "Spectral",
  palcolor = NULL,
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  aspect.ratio = 1,
  legend.position = "right",
  legend.direction = "vertical",
  seed = 8525,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{x}{A character string specifying the column name of the data frame to plot for the x-axis.}

\item{y}{A character string specifying the column name of the data frame to plot for the y-axis.}

\item{ytrans}{A function to transform the y-axis values.}

\item{color_by}{A character vector of column names to color the points by.
If NULL, the points will be filled by the x and y cutoff value.}

\item{color_name}{A character string to name the legend of color.}

\item{flip_negatives}{A logical value to flip the y-axis for negative x values.}

\item{x_cutoff}{A numeric value to set the x-axis cutoff.
Both negative and positive of this value will be used.}

\item{y_cutoff}{A numeric value to set the y-axis cutoff.
Note that the y-axis cutoff will be transformed by \code{ytrans}.
So you should provide the original value.}

\item{x_cutoff_name}{A character string to name the x-axis cutoff.
If "none", the legend for the x-axis cutoff will not be shown.}

\item{y_cutoff_name}{A character string to name the y-axis cutoff.
If "none", the legend for the y-axis cutoff will not be shown.}

\item{x_cutoff_color}{A character string to color the x-axis cutoff line.}

\item{y_cutoff_color}{A character string to color the y-axis cutoff line.}

\item{x_cutoff_linetype}{A character string to set the x-axis cutoff line type.}

\item{y_cutoff_linetype}{A character string to set the y-axis cutoff line type.}

\item{x_cutoff_linewidth}{A numeric value to set the x-axis cutoff line size.}

\item{y_cutoff_linewidth}{A numeric value to set the y-axis cutoff line size.}

\item{pt_size}{A numeric value to set the point size.}

\item{pt_alpha}{A numeric value to set the point transparency.}

\item{nlabel}{A numeric value to set the number of labels to show.
The points will be ordered by the distance to the origin. Top \code{nlabel} points will be labeled.}

\item{labels}{A character vector of row names or indexes to label the points.}

\item{label_size}{A numeric value to set the label size.}

\item{label_fg}{A character string to set the label color.}

\item{label_bg}{A character string to set the label background color.}

\item{label_bg_r}{A numeric value specifying the radius of the background of the label.}

\item{highlight}{A character vector of row names or indexes to highlight the points.}

\item{highlight_color}{A character string to set the highlight color.}

\item{highlight_size}{A numeric value to set the highlight size.}

\item{highlight_alpha}{A numeric value to set the highlight transparency.}

\item{highlight_stroke}{A numeric value to set the highlight stroke size.}

\item{facet_by}{A character string specifying the column name of the data frame to facet the plot.
Otherwise, the data will be split by \code{split_by} and generate multiple plots
and combine them into one using \code{patchwork::wrap_plots}}

\item{facet_scales}{Whether to scale the axes of facets. Default is "fixed"
Other options are "free", "free_x", "free_y". See \code{ggplot2::facet_wrap}}

\item{facet_ncol}{A numeric value specifying the number of columns in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_nrow}{A numeric value specifying the number of rows in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_byrow}{A logical value indicating whether to fill the plots by row. Default is TRUE.}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{palette}{A character string specifying the palette to use.}

\item{palcolor}{A character string specifying the color to use in the palette.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{xlab}{A character string specifying the x-axis label.}

\item{ylab}{A character string specifying the y-axis label.}

\item{aspect.ratio}{A numeric value specifying the aspect ratio of the plot.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{seed}{The random seed to use. Default is 8525.}

\item{...}{Additional arguments.}
}
\value{
A ggplot object
}
\description{
Atomic volcano plot
}
\keyword{internal}
