% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theming.R
\name{palette_this}
\alias{palette_this}
\title{Color palettes collected in plotthis.}
\usage{
palette_this(
  x,
  n = 100,
  palette = "Paired",
  palcolor = NULL,
  type = "auto",
  keep_names = TRUE,
  alpha = 1,
  matched = FALSE,
  reverse = FALSE,
  NA_keep = FALSE,
  NA_color = "grey80"
)
}
\arguments{
\item{x}{A vector of character/factor or numeric values. If missing, numeric values 1:n will be used as x.}

\item{n}{The number of colors to return for numeric values.}

\item{palette}{Palette name. All available palette names can be queried with \code{show_palettes()}.}

\item{palcolor}{Custom colors used to create a color palette.}

\item{type}{Type of \code{x}. Can be one of "auto", "discrete" or "continuous". The default is "auto", which automatically detects if \code{x} is a numeric value.}

\item{keep_names}{Whether to keep the names of the color vector.}

\item{alpha}{The alpha value of the colors. Default is 1.}

\item{matched}{If \code{TRUE}, will return a color vector of the same length as \code{x}.}

\item{reverse}{Whether to invert the colors.}

\item{NA_keep}{Whether to keep the color assignment to NA in \code{x}.}

\item{NA_color}{Color assigned to NA if NA_keep is \code{TRUE}.}
}
\value{
A vector of colors.
}
\description{
Color palettes collected in plotthis.
}
