% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reducer.R
\name{reducer}
\alias{reducer}
\title{Create a reducer}
\usage{
reducer(initialfn = NULL, reducefn = NULL, name = NULL)
}
\arguments{
\item{initialfn}{An JavaScript initializing function}

\item{reducefn}{A JavaScript reducer function specified}

\item{name}{A name for the reducer (a string)}
}
\value{
A reducer (which is really just a \code{list} with some additional formatting)
}
\description{
Constructs a reducer that can be used to show alternative summaries
in a \code{plotscaper} plot.
}
\details{
\code{reducefn} and \code{initialfn} should be strings interpretable
as JavaScript functions. Further:
\itemize{
\item \code{initialfn} should take 0 arguments and just return some value (i.e. a thunk).
\item \code{reducefn} should take two arguments \code{previous} and \code{next} and return a result
of the same type as \code{previous}.
}
}
\examples{
r <- reducer(initialfn = "() => 0",
             reducefn = "(x, y) => Math.max(x, y)",
             name = "max")
create_schema(mtcars) |>
  add_barplot(c("cyl", "mpg"), options = list(reducer = r))

}
