% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/message_senders.R
\name{get_scale}
\alias{get_scale}
\title{Get a plot scale}
\usage{
get_scale(x, id = NULL, scale = NULL)
}
\arguments{
\item{x}{A \code{plotscaper} scene}

\item{id}{A string id of the plot. See \link{id}}

\item{scale}{A string id of the scale (\code{x}, \code{y}, \code{width}, \code{height}, \code{area}, or \code{size})}
}
\value{
A list of scale properties
}
\description{
This function returns a specific scale from a specifc plot
in a \code{plotscaper} scene.
}
\details{
This function is primarily meant for internal use, however, you can
use it to learn how \code{plotscaper} implements scales. The output can look
a bit overwhelming, however, it's not too complicated once you understand
how \code{plotscaper} scales work.

Each scale has two important properties:
\itemize{
\item Domain: The space values are translated \emph{from}
\item Codomain: The space values are translated \emph{to}
}

For example, in a typical scatterplot, the \code{x} scale might have the range of
the data (e.g. \verb{[1, 10]}) as its domain and the width of the plotting region
as its codomain (e.g. \verb{[0, 800]} pixels).

The scale's job is to link the domain and codomain, such that
we can \emph{push} values forward through the scale, first through the domain
and then the codomain. This is done by translating to an intermediate
range \verb{[0, 1]}. For example, using the \code{x} scale above, we might first
translate the value \code{5.5} to \code{0.5} (midpoint of the domain) and then
translate \code{0.5} to \code{400} (midpoint of the codomain). We may also be able
to reverse the process and \emph{pull} values back through the scale, first
through the codomain and then through the domain.

Scale, domain, and codomain each have \code{props} and \code{defaults} properties
which store the relevant values. For example, for a continuous scale,
\code{props} and \code{defaults} store the \code{min} and \code{max} as well as a transformation
function and its inverse (\code{trans}, \code{inv}), for a discrete point scale,
they store the vector of labels, their order, etc...

On \code{scale}, the \code{props} and \code{defaults} store the following properties:
\code{zero}, \code{one}, \code{scale}, \code{mult}. The \code{zero} and \code{one} properties modify where
the normalized domain values get placed in the codomain, and vice versa.
Suppose our \code{x} (\verb{[1, 10]}, \verb{[0, 800]} px) scale had \code{zero = 0.1} and \code{one = 0.9}.
Then data values get pushed to the following intermediate values:
\itemize{
\item The value \code{1} to \code{0.1} since \code{0.1 + (1 - 1) / (10 - 1) * (0.9 - 0.1) = 0.1}
\item The value \code{2} to \code{0.1889} since \code{0.1 + (2 - 1) / (10 - 1) * (0.9 - 0.1) = 0.1889}
\item The value \code{3} to \code{0.2778} since \code{0.1 + ((3 - 1) / (10 - 1)) * (0.9 - 0.1) = 0.2778}
\item ...
\item The value \code{10} to \code{0.9} since \code{0.1 + ((10 - 1) / (10 - 1)) * (0.9 - 0.1) = 0.9}
}

When those values get translated to the space of the codomain,
we end up with 10\% margins on each side, i.e.
\itemize{
\item The value \code{1} gets pushed to \code{80} pixels
\item ...
\item The value \code{10} gets pushed to \code{720} pixels
}

The \code{scale} and \code{mult} properties both multiply the normalized domain values.
They work the same way, however, they are different semantically: \code{scale} is
meant to be constant whereas \code{mult} may change dynamically,
through interaction. For example, by default, in a barplot, the \code{width} scale
gets assigned the \code{scale} value of \code{1 / k}, where \code{k} is the number of
categories/bars, and a \code{mult} value of 0.9. This means that each bar is
\verb{1 / k * 0.9 * [plot width in pixels]} wide, and we can dynamically make it
wider or narrower by pressing the \verb{+/-} keys to modify the \code{mult} property
(but not the \code{scale} property).
}
