% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animate.R
\name{animation_opts}
\alias{animation_opts}
\alias{animation}
\alias{animation_slider}
\alias{animation_button}
\title{Animation configuration options}
\usage{
animation_opts(p, frame = 500, transition = frame, easing = "linear",
  redraw = TRUE, mode = "immediate")

animation_slider(p, hide = FALSE, ...)

animation_button(p, ..., label)
}
\arguments{
\item{p}{a plotly object.}

\item{frame}{The amount of time between frames (in milliseconds).
Note that this amount should include the \code{transition}.}

\item{transition}{The duration of the smooth transition between
frames (in milliseconds).}

\item{easing}{The type of transition easing. See the list of options here
\url{https://github.com/plotly/plotly.js/blob/master/src/plots/animation_attributes.js}}

\item{redraw}{Trigger a redraw of the plot at completion of the transition?
A redraw may significantly impact performance, but may be necessary to
update graphical elements that can't be transitioned.}

\item{mode}{Describes how a new animate call interacts with currently-running
animations. If \code{immediate}, current animations are interrupted and
the new animation is started. If \code{next}, the current frame is allowed
to complete, after which the new animation is started. If \code{afterall}
all existing frames are animated to completion before the new animation
is started.}

\item{hide}{remove the animation slider?}

\item{...}{for \code{animation_slider}, attributes are passed to a special
layout.sliders object tied to the animation frames.
The definition of these attributes may be found here
\url{https://github.com/plotly/plotly.js/blob/master/src/components/sliders/attributes.js}
For \code{animation_button}, arguments are passed to a special
layout.updatemenus button object tied to the animation
\url{https://github.com/plotly/plotly.js/blob/master/src/components/updatemenus/attributes.js}}

\item{label}{a character string used for the animation button's label}
}
\description{
Animations can be created by either using the \code{frame} argument in
\code{\link[=plot_ly]{plot_ly()}} or the (unofficial) \code{frame} ggplot2 aesthetic in
\code{\link[=ggplotly]{ggplotly()}}. By default, animations populate a play button
and slider component for controlling the state of the animation
(to pause an animation, click on a relevant location on the slider bar).
Both the play button and slider component transition between frames according
rules specified by \code{\link[=animation_opts]{animation_opts()}}.
}
\examples{

df <- data.frame(
  x = c(1, 2, 2, 1, 1, 2),
  y = c(1, 2, 2, 1, 1, 2),
  z = c(1, 1, 2, 2, 3, 3)
)
plot_ly(df) \%>\%
  add_markers(x = 1.5, y = 1.5) \%>\%
  add_markers(x = ~x, y = ~y, frame = ~z)

# it's a good idea to remove smooth transitions when there is
# no relationship between objects in each view
plot_ly(mtcars, x = ~wt, y = ~mpg, frame = ~cyl) \%>\%
  animation_opts(transition = 0)

# works the same way with ggplotly
if (interactive()) {
  p <- ggplot(txhousing, aes(month, median)) +
    geom_line(aes(group = year), alpha = 0.3) +
    geom_smooth() +
    geom_line(aes(frame = year, ids = month), color = "red") +
    facet_wrap(~ city)
 
  ggplotly(p, width = 1200, height = 900) \%>\%
    animation_opts(1000)
}

  
#' # for more, see https://cpsievert.github.io/plotly_book/key-frame-animations.html

}
\author{
Carson Sievert
}
