% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation_shading_polygon.R
\name{annotation_shading_polygon}
\alias{annotation_shading_polygon}
\title{Layer for Drawing a Single 
Irregular Polygon 
with Shading Colors}
\usage{
annotation_shading_polygon(shape = data.frame(c(-1, 1, 0), c(0, 0,
  1.732)), xmin = NULL, xmax = NULL, ymin = NULL, ymax = NULL,
  raster = NULL, interpolate = TRUE, result_interpolate = TRUE,
  shape_trim = NULL, raster_trim = NULL, result_trim = NULL,
  result = c("layer", "magick"), width = 800, height = NULL,
  res = 72)
}
\arguments{
\item{shape}{the polygon can be 
a data frame (or matrix object, or tbl_df object) 
with x and y coordinates, 
a plot created by ggplot or a image 
read into R by \code{magick::image_read}.}

\item{xmin}{the left side of the position to 
put the polygon. When 
\code{shape} is something like a data frame, 
you do not need to set xmin, xmax, ymin and ymax, 
for the function will generate these values according 
to the coordinates in the polygon.}

\item{xmax}{the right side.}

\item{ymin}{the bottom side.}

\item{ymax}{the top side.}

\item{raster}{the shading colors. 
It can be a raster object, 
a matrix of colors, a ggplot plot or an 
image read into R by 
\code{magick::image_read}.}

\item{interpolate}{the \code{interpolate}
argument used by \code{ggplot2::annotation_raster}
when the \code{raster} argument is a matrix or 
raster.}

\item{result_interpolate}{whether to interpolate in the 
final result which is essentially an output of 
\code{ggplot2::annotation_raster}. Default is TRUE.}

\item{shape_trim}{this argument 
decides whether to trim edges 
of \code{shape}.
It should be a number 
between 0 and 100. Default is NULL. If it is NULL, 
no trimming will be done.}

\item{raster_trim}{whether to trim raster. 
Most of the time we do want to trim the raster.
However, the \code{magick::image_trim} function 
sometimes trims wrongly. So you may want to turn 
it off. Default is NULL.}

\item{result_trim}{how to trim the 
final result. If you find your 
figure loses some parts, you can try to turn this off. 
Default is NULL.}

\item{result}{when it is "layer", the function is a
ggplot layer. When it is "magick", the function only 
create an image.}

\item{width}{the width which will be passed 
to \code{magick::image_graph}. Most of the time you do 
not need to modify this. Default is 800. HOWEVER, if the 
final polygon has fuzzy edges, try to enlarge \code{width} 
to make them look better.}

\item{height}{the height which will be passed 
to \code{magick::image_graph}. Most of the time you do 
not need to modify this. Default is NULL, which means 
it will be computed automatically.}

\item{res}{resolution in pixels which will be passed to 
\code{magick::image_graph}. Default is 72.}
}
\description{
\code{ggplot2::annotation_raster} can only 
draw shading rectangles. However, this 
function can draw polygons of any shape 
with shading colors. See the \code{shape} 
argument and the \code{raster} argument.
}
\examples{
\donttest{
# Example 1
poly=ellipsexy(-1, 0, a=1, b=1)
m=matrix(rainbow(7))
ggplot()+
	coord_fixed(expand=FALSE)+
	xlim(-3, 6)+ylim(-1.5, 1.5)+
	annotation_shading_polygon(
		poly, 
		raster=m
	)+
	annotation_shading_polygon(
		poly, 
		xmin=1, xmax=5, 
		ymin=-1, ymax=1, 
		raster=m
	)
#
# Example 2, only an image
tt=annotation_shading_polygon(
	poly, 
	result="magick", 
	width=280, height=280
)
#
# Example 3, both shape and raster are 
# ggplot plots.
p1=ggplot()+coord_fixed()+
	geom_tile(aes(x=1: 5, y=1: 5))
p2=ggplot()+theme_void()+
	coord_cartesian(expand=FALSE)+
	geom_polygon(aes(x=c(0, 1, 1, 0), 
		y=c(0, 0, 1, 1)), fill="red")
ggplot()+xlim(0, 11)+ylim(0, 6)+coord_fixed()+
	annotation_shading_polygon(
		shape=p1, 
		xmin=1, xmax=10, 
		ymin=1, ymax=5, 
		raster=p2
	)
}
}
