% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XB2P.R
\name{XB2P}
\alias{XB2P}
\alias{X2P}
\alias{XB2P_cat3logit}
\alias{X2P_cat3logit}
\alias{XB2P_ord3logit}
\alias{X2P_ord3logit}
\title{Computes trinomial probability distributions implied by linear predictors}
\usage{
XB2P(XB, model)

X2P(X, B, model)

XB2P_cat3logit(XB)

X2P_cat3logit(X, B)

XB2P_ord3logit(XB, alpha)

X2P_ord3logit(X, B, alpha)
}
\arguments{
\item{XB}{object of class \code{matrix} (or other coercible classes) such that
\eqn{XB\in\textbf{R}^{n\times 2}} for \emph{categorical} models or
\eqn{XB\in\textbf{R}^n} for \emph{ordinal} models.}

\item{model}{object of class \code{field3logit}.}

\item{X}{object of class \code{matrix} (or other coercible classes) such that
\eqn{X\in\textbf{R}^{n\times k}}.}

\item{B}{object of class \code{matrix} (or other coercible classes) such that
\eqn{B\in\textbf{R}^{k\times 2}} for \emph{categorical} models or
\eqn{B\in\textbf{R}^k} for \emph{ordinal} models.}

\item{alpha}{\code{numeric} vector of length two where constants \eqn{\alpha^{(1)}}
and \eqn{\alpha^{(2)}} are stored (only for ordinal models), as
defined in Equation (7) of \insertCite{santi2019;textual}{plot3logit}.}
}
\value{
Numeric matrix \eqn{[0,\,1]^{n\times 3}} of probability distributions.
}
\description{
\code{XB2P_cat3logit} and \code{XB2P_ord3logit} compute the matrix
\eqn{P\in[0,\,1]^{n\times 3}} of probability distributions of the
dependent variable for categorical and ordinal models respectively.
Functions \code{X2P_cat3logit} and \code{X2P_ord3logit} perform the same computation,
except that the design matrix \eqn{X\in\textbf{R}^{n\times k}} and
the coefficient matrix \eqn{B\in\textbf{R}^{k\times 2}} are taken as
separate input arguments. \code{XB2P} and \code{X2P} apply the proper function
according to the type of model passed to argument \code{model}.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{P2XB}}.
}
\keyword{internal}
