% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed.R
\name{scanBED}
\alias{scanBED}
\title{Scan genotypes in PLINK BED(s)}
\usage{
scanBED(pfx, FUN, ..., simplify = TRUE)
}
\arguments{
\item{pfx}{prefix of PLINK BED.}

\item{FUN}{the function to process each variant.}

\item{...}{additional argument to pass to \emph{\code{FUN}}.}

\item{simplify}{TRUE to simplify the result as an array.}
}
\value{
an array with each row  corresponding to a variant if simplify is set
    to TRUE; otherwise,  a list with each element corresponding  to a variant
    is returned.

A  context  vaiable  ".i"  is  assigned to  the  environment  of  \code{FUN},
therefore, one can  access the index of variant current  being processed from
within the body of \code{FUN}.
}
\description{
Go through a BED file set and visit  one variant at a time. This is meant for
out-of-memory screening of huge genotype, such as a GWAS study.
}
\details{
To read an entire BED into a R matrix, see \code{\link{readBED}} instead.

A BED (\emph{binary biallelic genotype table}) is comprised of three files
(usually) sharing identical prefix:
\itemize{
  \item {pfx}.fam: table of N typed individuals
  \item {pfx}.bim: table of P typed genomic variants (i.e., SNPs);
  \item {pfx}.bed: genotype matrix of N rows and P columns stored in condensed
  binary format.
}

The three files are commonly referred by their common prefix, e.g.:

chrX.bed, chrX.fam, and chrX.bim, are jointly specified by "chrX".
}
\examples{
pfx <- file.path(system.file("extdata", package="plinkFile"), "000")
ret <- scanBED(pfx, function(g)
{
    af <- mean(g, na.rm=TRUE) / 2
    maf <- min(af, 1 - af)
    c(idx=.i, mu=mean(g, na.rm=TRUE), maf=maf, nas=sum(is.na(g)))
})
print(ret[1:5, ])

}
\seealso{
{readBED}
}
