% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_objects.R
\name{object_bbox}
\alias{object_bbox}
\title{Compute Bounding Boxes from Contours}
\usage{
object_bbox(contours)
}
\arguments{
\item{contours}{A list of matrices, where each matrix contains two columns
representing (x, y) coordinates of a contour.}
}
\value{
A list of bounding boxes, where each bounding box is represented as a
list with \code{x_min}, \code{y_min}, \code{x_max}, and \code{y_max} values.
}
\description{
This function calculates the bounding boxes for a given list of contours.
}
\examples{
if(interactive()){
contours <- list(
  matrix(c(10, 20, 30, 40, 50, 60, 70, 80, 90, 100,
           110, 120, 130, 140, 150, 160, 170, 180, 190, 200),
         ncol = 2, byrow = FALSE)
)
bbox_list <- object_bbox(contours)
print(bbox_list)
}

}
