% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_objects.R
\name{object_export}
\alias{object_export}
\title{Export multiple objects from an image to multiple images}
\usage{
object_export(
  img,
  pattern = NULL,
  dir_original = NULL,
  dir_processed = NULL,
  format = ".jpg",
  squarize = FALSE,
  index = "NB",
  lower_size = NULL,
  watershed = TRUE,
  invert = FALSE,
  fill_hull = FALSE,
  filter = 2,
  threshold = "Otsu",
  extension = NULL,
  tolerance = NULL,
  object_size = "medium",
  edge = 20,
  remove_bg = FALSE,
  parallel = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{img}{The image to be analyzed.}

\item{pattern}{A pattern of file name used to identify images to be
processed. For example, if \code{pattern = "im"} all images in the current
working directory that the name matches the pattern (e.g., img1.-,
image1.-, im2.-) will be imported and processed. Providing any number as
pattern (e.g., \code{pattern = "1"}) will select images that are named as 1.-,
2.-, and so on. An error will be returned if the pattern matches any file
that is not supported (e.g., img1.pdf).}

\item{dir_original}{The directory containing the original images. Defaults to
\code{NULL}. It can be either a full path, e.g., \code{"C:/Desktop/imgs"}, or a
subfolder within the current working directory, e.g., \code{"/imgs"}.}

\item{dir_processed}{Optional character string indicating a subfolder within the
current working directory to save the image(s). If the folder doesn't
exist, it will be created.}

\item{format}{The format of image to be exported.}

\item{squarize}{Squarizes the image before the exportation? If \code{TRUE},
\code{\link[=image_square]{image_square()}} will be called internally.}

\item{index}{A character value specifying the target mode for conversion to
binary image when \code{foreground} and \code{background} are not declared. Defaults
to \code{"NB"} (normalized blue). See \code{\link[=image_index]{image_index()}} for more details. User can
also calculate your own index using the bands names, e.g. \code{index = "R+B/G"}}

\item{lower_size}{Plant images often contain dirt and dust. To prevent dust from
affecting the image analysis, objects with lesser than 10\% of the mean of all objects
are removed. Set \code{lower_limit = 0} to keep all the objects.}

\item{watershed}{If \code{TRUE} (default) performs watershed-based object
detection. This will detect objects even when they are touching one other.
If \code{FALSE}, all pixels for each connected set of foreground pixels are set
to a unique object. This is faster but is not able to segment touching
objects.}

\item{invert}{Inverts the binary image if desired. This is useful to process
images with a black background. Defaults to \code{FALSE}. If \code{reference = TRUE}
is use, \code{invert} can be declared as a logical vector of length 2 (eg.,
\verb{invert = c(FALSE, TRUE}). In this case, the segmentation of objects and
reference from the foreground using \code{back_fore_index} is performed using the
default (not inverted), and the segmentation of objects from the reference
is performed by inverting the selection (selecting pixels higher than the
threshold).}

\item{fill_hull}{Fill holes in the binary image? Defaults to \code{FALSE}. This is
useful to fill holes in objects that have portions with a color similar to
the background. IMPORTANT: Objects touching each other can be combined into
one single object, which may underestimate the number of objects in an
image.}

\item{filter}{Performs median filtering in the binary image? See more at
\code{\link[=image_filter]{image_filter()}}. Defaults to \code{FALSE}. Use a positive integer to define the
size of the median filtering. Larger values are effective at removing noise,
but adversely affect edges.}

\item{threshold}{The theshold method to be used.
\itemize{
\item By default (\code{threshold = "Otsu"}), a threshold value based
on Otsu's method is used to reduce the grayscale image to a binary image. If
a numeric value is informed, this value will be used as a threshold.
\item If \code{threshold = "adaptive"}, adaptive thresholding (Shafait et al. 2008)
is used, and will depend on the \code{k} and \code{windowsize} arguments.
\item If any non-numeric value different than \code{"Otsu"} and \code{"adaptive"} is used,
an iterative section will allow you to choose the threshold based on a
raster plot showing pixel intensity of the index.
}}

\item{extension}{Radius of the neighborhood in pixels for the detection of
neighboring objects. Higher value smooths out small objects.}

\item{tolerance}{The minimum height of the object in the units of image
intensity between its highest point (seed) and the point where it contacts
another object (checked for every contact pixel). If the height is smaller
than the tolerance, the object will be combined with one of its neighbors,
which is the highest.}

\item{object_size}{The size of the object. Used to automatically set up
\code{tolerance} and \code{extension} parameters. One of the following. \code{"small"}
(e.g, wheat grains), \code{"medium"} (e.g, soybean grains), \code{"large"}(e.g, peanut
grains), and \code{"elarge"} (e.g, soybean pods)`.}

\item{edge}{The number of pixels to be added in the edge of the segmented
object. Defaults to 5.}

\item{remove_bg}{If \code{TRUE}, the pixels that are not part of objects are
converted to white.}

\item{parallel}{If \code{TRUE} processes the images asynchronously (in parallel) in
separate R sessions running in the background on the same machine. It may
speed up the processing time, especially when \code{pattern} is used is informed.
When \code{object_index} is informed, multiple sections will be used to extract
the RGB values for each object in the image. This may significantly speed up
processing time when an image has lots of objects (say >1000).}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}
}
\value{
A \code{NULL} object.
}
\description{
Givin an image with multiple objects, \code{object_export()} will split the
objects into a list of objects using \code{\link[=object_split]{object_split()}} and then export them to
multiple images into the current working directory (or a subfolder). Batch
processing is performed by declaring a file name pattern that matches the
images within the working directory.
}
\examples{
if(interactive()){
library(pliman)
img <- image_pliman("la_leaves.jpg")
object_export(img)

}
}
