% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaf_area.R
\name{leaf_area}
\alias{leaf_area}
\title{Calculates the leaf area}
\usage{
leaf_area(
  img,
  img_leaf,
  img_background,
  img_template,
  area_template,
  parallel = FALSE,
  workers = NULL,
  img_pattern = NULL,
  lower_size = NULL,
  upper_size = NULL,
  randomize = TRUE,
  nrows = 10000,
  show_image = TRUE,
  show_original = TRUE,
  show_background = TRUE,
  col_background = NULL,
  col_leaf = "green",
  text_col = "black",
  text_size = 1,
  text_digits = 2,
  save_image = FALSE,
  dir_original = NULL,
  dir_processed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{img}{The image to be analyzed.}

\item{img_leaf}{A color palette of the leaves.}

\item{img_background}{A color palette of background area.}

\item{img_template}{A color palette of the template areas.}

\item{area_template}{The known area of the template. The leaf area will be
given in the same unit as \code{area_template}.}

\item{parallel}{Processes the images asynchronously (in parallel) in separate
R sessions running in the background on the same machine. It may speed up
the processing time, especially when \code{img_pattern} is used is informed. The
number of sections is set up to 90\% of available cores.}

\item{workers}{A positive numeric scalar or a function specifying the maximum
number of parallel processes that can be active at the same time.}

\item{img_pattern}{A pattern of file name used to identify images to be
processed. For example, if \code{img_pattern = "im"} all images that the name
matches the pattern (e.g., img1.-, image1.-, im2.-) will be analyzed.
Providing any number as pattern (e.g., \code{img_pattern = "1"}) will select
images that are named as 1.-, 2.-, and so on.}

\item{lower_size}{Lower limit for size for the image analysis. Leaf images
often contain dirt and dust. To prevent dust from affecting the image
analysis, the lower limit of analyzed size is set to 0.1, i.e., objects
with lesser than 10\% of the mean of all objects are removed. One can set a
known area or use \code{lower_limit = 0} to select all objects (not advised).}

\item{upper_size}{Upper limit for size for the image analysis. Defaults to
\code{NULL}, i.e., no upper limit used.}

\item{randomize}{Randomize the lines before training the model?}

\item{nrows}{The number of lines to be used in training step.}

\item{show_image}{Show image after processing?}

\item{show_original}{Show the symptoms in the original image?}

\item{show_background}{Show the background? Defaults to \code{TRUE}. A white
background is shown by default when \code{show_original = FALSE}.}

\item{col_background}{Background color after image processing.}

\item{col_leaf}{Leaf color after image processing when \code{show_original = FALSE}. Defaults to \code{"green"}.}

\item{text_col, text_size, text_digits}{The color, size and significant digits
used in the text. The shows the pattern \code{o|a}, where \code{o} and \code{a} are the
object id and its area, respectively.}

\item{save_image}{Save the image after processing? The image is saved in the
current working directory named as \verb{proc_*} where \code{*} is the image name
given in \code{img}.}

\item{dir_original, dir_processed}{The directory containing the original and
processed images. Defaults to \code{NULL}. In this case, the function will
search for the image \code{img} in the current working directory. After
processing, when \code{save_image = TRUE}, the processed image will be also
saved in such a directory.}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}
}
\value{
A data frame with the results for each image.
}
\description{
\itemize{
\item \code{leaf_area ()} Calculates the leaf area using an image with leaves and a
template with a known area. A general linear model (binomial family) fitted to
the RGB values is used to first separate the leaves and template from the
background and then the leaves from the template. The leaf area is then
calculated for each leaf based on the pixel area. By using \code{img_pattern} it is
possible to process several images with common pattern names that are stored
in the current working directory or in the subdirectory informed in
\code{dir_originals}.
}
}
\examples{
\donttest{
library(pliman)
img <- image_import(image_pliman("la_pattern.JPG"))
leaf <- image_import(image_pliman("la_leaf.jpg"))
tmpl <- image_import(image_pliman("la_temp.jpg"))
background <- image_import(image_pliman("la_back.jpg"))

# Combine the images
image_combine(img, leaf, tmpl, background)

# Computes the leaf area
area <-
leaf_area(img = img,
          img_leaf = leaf,
          img_template = tmpl,
          img_background = background,
          area_template = 4,
          text_col = "white")
get_measures(area)
}

}
