% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ItemGPCM_data.R
\name{ItemGPCM.data}
\alias{ItemGPCM.data}
\title{Creates data frame up-dating phi parameters of the gpcm.}
\usage{
ItemGPCM.data(
  Master,
  ItemID,
  Phi.mat,
  TraitByTrait,
  pq.mat,
  starting.sv,
  npersons,
  nitems,
  ncat,
  nless,
  ntraits,
  LambdaName
)
}
\arguments{
\item{Master}{Data frame of all data in long format}

\item{ItemID}{Specifies the item for which a data frame is created to be
input into an item regression}

\item{Phi.mat}{Starting value of matrix of association parameters}

\item{TraitByTrait}{Trait by trait adjacency matrix (same as inTraitAdj)}

\item{pq.mat}{Array used to compute rest scores}

\item{starting.sv}{Matrix of item category scores that are fixed}

\item{npersons}{Number of persons}

\item{nitems}{Number of items}

\item{ncat}{Number of categories}

\item{nless}{Number of unique lambdas (ncat-1)}

\item{ntraits}{Number of latent traits}

\item{LambdaName}{Names for lambda for item regression}
}
\value{
gpcm.item.data  Data frame for item to be used up-dated in an item regression for specified item
}
\description{
This function creates a data frame, 'gpcm.item.data', to be used in the item
regressions of LMA models where category scales values are fixed. Sets up data
for up-dating alpha parameters of the LMA that corresponds to the GPCM. This
function is internal to 'item.gpcm' and it is unlikely to be run outside of
'fit.gpcm' or 'ple.lma'.
}
